/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.extension;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.n52.io.extension.StatusIntervalsExtensionConfig;
import org.n52.io.request.IoParameters;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.StatusInterval;
import org.n52.io.response.TimeseriesMetadataOutput;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.extension.MetadataExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusIntervalsExtension
extends MetadataExtension<DatasetOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusIntervalsExtension.class);
    private static final String CONFIG_FILE = "/config-status-intervals.json";
    private static final String EXTENSION_NAME = "statusIntervals";
    private final StatusIntervalsExtensionConfig intervalConfig = this.readConfig();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StatusIntervalsExtensionConfig readConfig() {
        try (InputStream config = ((Object)((Object)this)).getClass().getResourceAsStream(CONFIG_FILE);){
            ObjectMapper om = new ObjectMapper();
            StatusIntervalsExtensionConfig statusIntervalsExtensionConfig = (StatusIntervalsExtensionConfig)om.readValue(config, StatusIntervalsExtensionConfig.class);
            return statusIntervalsExtensionConfig;
        }
        catch (Exception e) {
            LOGGER.error("Could not load {). Using empty config.", (Object)CONFIG_FILE, (Object)e);
            return new StatusIntervalsExtensionConfig();
        }
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public void addExtraMetadataFieldNames(DatasetOutput output) {
        if (this.hasStatusIntervals(output)) {
            output.addExtra(EXTENSION_NAME);
        }
    }

    private boolean hasStatusIntervals(DatasetOutput output) {
        return this.hasSeriesConfiguration(output) || this.hasPhenomenonConfiguration(output);
    }

    private boolean hasSeriesConfiguration(DatasetOutput output) {
        String id = output.getId();
        return this.intervalConfig.getTimeseriesIntervals().containsKey(id);
    }

    private boolean hasPhenomenonConfiguration(DatasetOutput output) {
        String id = output.getId();
        return this.intervalConfig.getPhenomenonIntervals().containsKey(id);
    }

    public Map<String, Object> getExtras(DatasetOutput output, IoParameters parameters) {
        if (!this.hasExtrasToReturn(output, parameters)) {
            return Collections.emptyMap();
        }
        if (this.hasSeriesConfiguration(output)) {
            StatusInterval[] intervals = this.createIntervals(this.getSeriesIntervals(output));
            this.checkForBackwardCompatiblity(output, intervals);
            return this.wrapSingleIntoMap(intervals);
        }
        if (this.hasPhenomenonConfiguration(output)) {
            StatusInterval[] intervals = this.createIntervals(this.getPhenomenonIntervals(output));
            this.checkForBackwardCompatiblity(output, intervals);
            return this.wrapSingleIntoMap(intervals);
        }
        LOGGER.error("No status intervals found for {} (id={})", (Object)output, (Object)output.getId());
        return Collections.emptyMap();
    }

    private boolean hasExtrasToReturn(DatasetOutput output, IoParameters parameters) {
        return super.hasExtrasToReturn((ParameterOutput)output, parameters) && this.hasStatusIntervals(output);
    }

    private StatusIntervalsExtensionConfig.ConfigInterval getSeriesIntervals(DatasetOutput output) {
        return this.intervalConfig.getTimeseriesIntervals().get(output.getId());
    }

    private StatusIntervalsExtensionConfig.ConfigInterval getPhenomenonIntervals(DatasetOutput output) {
        String id = output.getSeriesParameters().getPhenomenon().getId();
        return this.intervalConfig.getPhenomenonIntervals().get(id);
    }

    private StatusInterval[] createIntervals(StatusIntervalsExtensionConfig.ConfigInterval configInterval) {
        Map<String, StatusInterval> statusIntervals = configInterval.getStatusIntervals();
        for (Map.Entry<String, StatusInterval> entry : statusIntervals.entrySet()) {
            StatusInterval value = entry.getValue();
            value.setName(entry.getKey());
        }
        return statusIntervals.values().toArray(new StatusInterval[0]);
    }

    private void checkForBackwardCompatiblity(DatasetOutput output, StatusInterval[] intervals) {
        if (output instanceof TimeseriesMetadataOutput) {
            ((TimeseriesMetadataOutput)output).setStatusIntervals(intervals);
        }
    }
}

