/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.n52.io.DatasetFactoryException;
import org.n52.io.DefaultIoFactory;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.IoFactory;
import org.n52.io.IoProcessChain;
import org.n52.io.MimeType;
import org.n52.io.PreRenderingJob;
import org.n52.io.request.IoParameters;
import org.n52.io.request.QueryParameters;
import org.n52.io.request.RequestParameterSet;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.request.RequestStyledParameterSet;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DataCollection;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.DatasetType;
import org.n52.series.spi.srv.DataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.series.spi.srv.RawDataService;
import org.n52.web.ctrl.BaseController;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/v1/datasets"}, produces={"application/json"})
public class DataController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataController.class);
    private static final String DEFAULT_RESPONSE_ENCODING = "UTF-8";
    @Autowired
    private DefaultIoFactory<Data<AbstractValue<?>>, DatasetOutput<AbstractValue<?>, ?>, AbstractValue<?>> ioFactoryCreator;
    private DataService<Data<AbstractValue<?>>> dataService;
    private ParameterService<DatasetOutput<AbstractValue<?>, ?>> datasetService;
    private PreRenderingJob preRenderingTask;
    private String requestIntervalRestriction;

    @RequestMapping(value={"/data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView getSeriesData(HttpServletResponse response, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters parameters = QueryParameters.createFromQuery(query);
        LOGGER.debug("get data with query: {}", (Object)parameters);
        return this.getSeriesCollectionData(response, parameters.toSimpleParameterSet());
    }

    @RequestMapping(value={"/data"}, produces={"application/json"}, method={RequestMethod.POST})
    public ModelAndView getSeriesCollectionData(HttpServletResponse response, @RequestBody RequestSimpleParameterSet parameters) throws Exception {
        LOGGER.debug("get data collection with parameter set: {}", (Object)parameters);
        this.checkForUnknownSeriesIds((RequestParameterSet)parameters, parameters.getDatasets());
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        String datasetType = parameters.getDatasetType();
        IoProcessChain ioChain = this.createIoFactory(datasetType).withSimpleRequest(parameters).createProcessChain();
        DataCollection processed = ioChain.getData();
        return new ModelAndView().addObject((Object)processed.getAllSeries());
    }

    @RequestMapping(value={"/{seriesId}/data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView getSeriesData(HttpServletResponse response, @PathVariable String seriesId, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters map = QueryParameters.createFromQuery(query);
        LOGGER.debug("get data for item '{}' with query: {}", (Object)seriesId, (Object)map);
        IntervalWithTimeZone timespan = map.getTimespan();
        this.checkAgainstTimespanRestriction(timespan.toString());
        this.checkForUnknownSeriesIds(map, seriesId);
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)seriesId, (IoParameters)map);
        String handleAsDatasetFallback = map.getAsString("handleAs");
        String datasetType = DatasetType.extractType((String)seriesId, (String)handleAsDatasetFallback);
        IoProcessChain ioChain = this.createIoFactory(datasetType).withSimpleRequest(parameters).createProcessChain();
        DataCollection formattedDataCollection = ioChain.getProcessedData();
        Map processed = formattedDataCollection.getAllSeries();
        return map.isExpanded() ? new ModelAndView().addObject((Object)processed) : new ModelAndView().addObject(processed.get(seriesId));
    }

    @RequestMapping(value={"/data"}, params={"rawFormat"}, method={RequestMethod.POST})
    public void getRawSeriesCollectionData(HttpServletResponse response, @RequestBody RequestSimpleParameterSet parameters) throws Exception {
        this.checkForUnknownSeriesIds((RequestParameterSet)parameters, parameters.getDatasets());
        LOGGER.debug("get raw data collection with parameters: {}", (Object)parameters);
        this.writeRawData(parameters, response);
    }

    @RequestMapping(value={"/{seriesId}/data"}, method={RequestMethod.GET}, params={"rawFormat"})
    public void getRawSeriesData(HttpServletResponse response, @PathVariable String seriesId, @RequestParam MultiValueMap<String, String> query) {
        IoParameters map = QueryParameters.createFromQuery(query);
        this.checkForUnknownSeriesIds(map, seriesId);
        LOGGER.debug("getSeriesCollection() with query: {}", (Object)map);
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)seriesId, (IoParameters)map);
        this.writeRawData(parameters, response);
    }

    private void writeRawData(RequestSimpleParameterSet parameters, HttpServletResponse response) throws InternalServerException, ResourceNotFoundException, BadRequestException {
        if (!this.dataService.supportsRawData()) {
            throw new BadRequestException("Querying of raw timeseries data is not supported by the underlying service!");
        }
        RawDataService rawDataService = this.dataService.getRawDataService();
        try (InputStream inputStream = rawDataService.getRawData(parameters);){
            if (inputStream == null) {
                throw new ResourceNotFoundException("No raw data found.");
            }
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new InternalServerException("Error while querying raw data", e);
        }
    }

    @RequestMapping(value={"/data"}, produces={"application/pdf"}, method={RequestMethod.POST})
    public void getSeriesCollectionReport(HttpServletResponse response, @RequestBody RequestStyledParameterSet parameters) throws Exception {
        IoParameters map = QueryParameters.createFromQuery((RequestParameterSet)parameters);
        LOGGER.debug("get data collection report with query: {}", (Object)map);
        this.checkForUnknownSeriesIds((RequestParameterSet)parameters, parameters.getDatasets());
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        String datasetType = parameters.getDatasetType();
        RequestSimpleParameterSet request = RequestSimpleParameterSet.createFromDesignedParameters((RequestStyledParameterSet)parameters);
        this.createIoFactory(datasetType).withSimpleRequest(request).withStyledRequest(parameters).createHandler(MimeType.APPLICATION_PDF.toString()).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{seriesId}/data"}, produces={"application/pdf"}, method={RequestMethod.GET})
    public void getSeriesReport(HttpServletResponse response, @PathVariable String seriesId, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters map = QueryParameters.createFromQuery(query);
        LOGGER.debug("get data collection report for '{}' with query: {}", (Object)seriesId, (Object)map);
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)seriesId, (IoParameters)map);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkForUnknownSeriesIds(map, seriesId);
        String datasetType = parameters.getDatasetType();
        this.createIoFactory(datasetType).withSimpleRequest(parameters).createHandler(MimeType.APPLICATION_PDF.toString()).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{seriesId}/data"}, produces={"application/zip"}, method={RequestMethod.GET})
    public void getSeriesAsZippedCsv(HttpServletResponse response, @PathVariable String seriesId, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters map = QueryParameters.createFromQuery(query);
        LOGGER.debug("get data collection zip for '{}' with query: {}", (Object)seriesId, (Object)map);
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)seriesId, (IoParameters)map);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkForUnknownSeriesIds(map, seriesId);
        response.setCharacterEncoding(DEFAULT_RESPONSE_ENCODING);
        response.setContentType(MimeType.APPLICATION_ZIP.toString());
        String datasetType = parameters.getDatasetType();
        this.createIoFactory(datasetType).withSimpleRequest(parameters).createHandler(MimeType.APPLICATION_ZIP.toString()).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{seriesId}/data"}, produces={"text/csv"}, method={RequestMethod.GET})
    public void getSeriesAsCsv(HttpServletResponse response, @PathVariable String seriesId, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters map = QueryParameters.createFromQuery(query);
        LOGGER.debug("get data collection csv for '{}' with query: {}", (Object)seriesId, (Object)map);
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)seriesId, (IoParameters)map);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkForUnknownSeriesIds(map, seriesId);
        response.setCharacterEncoding(DEFAULT_RESPONSE_ENCODING);
        if (Boolean.parseBoolean(map.getOther("zip"))) {
            response.setContentType(MimeType.APPLICATION_ZIP.toString());
        } else {
            response.setContentType(MimeType.TEXT_CSV.toString());
        }
        String datasetType = parameters.getDatasetType();
        this.createIoFactory(datasetType).withSimpleRequest(parameters).createHandler(MimeType.TEXT_CSV.toString()).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/data"}, produces={"image/png"}, method={RequestMethod.POST})
    public void getSeriesCollectionChart(HttpServletResponse response, @RequestBody RequestStyledParameterSet parameters) throws Exception {
        IoParameters map = QueryParameters.createFromQuery((RequestParameterSet)parameters);
        this.checkForUnknownSeriesIds(map, parameters.getDatasets());
        LOGGER.debug("get data collection chart with query: {}", (Object)map);
        String datasetType = parameters.getDatasetType();
        this.createIoFactory(datasetType).withStyledRequest(parameters).createHandler(MimeType.IMAGE_PNG.toString()).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{seriesId}/data"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getSeriesChart(HttpServletResponse response, @PathVariable String seriesId, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters map = QueryParameters.createFromQuery(query);
        LOGGER.debug("get data collection chart for '{}' with query: {}", (Object)seriesId, (Object)map);
        this.checkAgainstTimespanRestriction(map.getTimespan().toString());
        this.checkForUnknownSeriesIds(map, seriesId);
        String handleAsDatasetFallback = map.getAsString("handleAs");
        String observationType = DatasetType.extractType((String)seriesId, (String)handleAsDatasetFallback);
        RequestSimpleParameterSet parameters = map.toSimpleParameterSet();
        this.createIoFactory(observationType).withSimpleRequest(parameters).createHandler(MimeType.IMAGE_PNG.toString()).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{seriesId}/{chartQualifier}"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getSeriesChartByInterval(HttpServletResponse response, @PathVariable String seriesId, @PathVariable String chartQualifier, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        if (this.preRenderingTask == null) {
            throw new ResourceNotFoundException("Diagram prerendering is not enabled.");
        }
        if (!this.preRenderingTask.hasPrerenderedImage(seriesId, chartQualifier)) {
            throw new ResourceNotFoundException("No pre-rendered chart found for timeseries '" + seriesId + "'.");
        }
        LOGGER.debug("get prerendered chart for '{}' ({})", (Object)seriesId, (Object)chartQualifier);
        this.preRenderingTask.writePrerenderedGraphToOutputStream(seriesId, chartQualifier, (OutputStream)response.getOutputStream());
    }

    private void checkAgainstTimespanRestriction(String timespan) {
        Duration duration;
        if (this.requestIntervalRestriction != null && (duration = Period.parse((String)this.requestIntervalRestriction).toDurationFrom((ReadableInstant)new DateTime())).getMillis() < Interval.parse((String)timespan).toDurationMillis()) {
            throw new BadRequestException("Timespan too long, please use a period shorter than '" + this.requestIntervalRestriction + "'");
        }
    }

    private void checkForUnknownSeriesIds(RequestParameterSet parameters, String ... seriesIds) {
        this.checkForUnknownSeriesIds(IoParameters.createFromQuery((RequestParameterSet)parameters), seriesIds);
    }

    private void checkForUnknownSeriesIds(IoParameters parameters, String ... seriesIds) {
        if (seriesIds != null) {
            for (String id : seriesIds) {
                if (this.datasetService.exists(id, parameters)) continue;
                throw new ResourceNotFoundException("Series with id '" + id + "' wasn't found.");
            }
        }
    }

    private IoFactory<Data<AbstractValue<?>>, DatasetOutput<AbstractValue<?>, ?>, AbstractValue<?>> createIoFactory(String datasetType) throws DatasetFactoryException {
        if (!this.ioFactoryCreator.isKnown(datasetType)) {
            throw new ResourceNotFoundException("unknown dataset type: " + datasetType);
        }
        return ((IoFactory)this.ioFactoryCreator.create(datasetType)).withDataService(this.dataService).withDatasetService(this.datasetService);
    }

    private URI getRootResource() throws URISyntaxException, MalformedURLException {
        return this.getServletConfig().getServletContext().getResource("/").toURI();
    }

    public PreRenderingJob getPreRenderingTask() {
        return this.preRenderingTask;
    }

    public void setPreRenderingTask(PreRenderingJob prerenderingTask) {
        this.preRenderingTask = prerenderingTask;
    }

    public String getRequestIntervalRestriction() {
        return this.requestIntervalRestriction;
    }

    public void setRequestIntervalRestriction(String requestIntervalRestriction) {
        Period.parse((String)requestIntervalRestriction);
        LOGGER.debug("CONFIG: request.interval.restriction={}", (Object)requestIntervalRestriction);
        this.requestIntervalRestriction = requestIntervalRestriction;
    }

    public DataService<Data<AbstractValue<?>>> getDataService() {
        return this.dataService;
    }

    public void setDataService(DataService<Data<AbstractValue<?>>> dataService) {
        this.dataService = dataService;
    }

    public ParameterService<DatasetOutput<AbstractValue<?>, ?>> getDatasetService() {
        return this.datasetService;
    }

    public void setDatasetService(ParameterService<DatasetOutput<AbstractValue<?>, ?>> datasetService) {
        this.datasetService = datasetService;
    }
}

