/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.n52.io.response.ParameterOutput;
import org.n52.web.common.RequestUtils;
import org.n52.web.ctrl.ParameterController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
public abstract class ParameterRequestMappingAdapter<T extends ParameterOutput>
extends ParameterController<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterRequestMappingAdapter.class);

    @Override
    @RequestMapping(path={""})
    public ModelAndView getCollection(@RequestParam MultiValueMap<String, String> query) {
        return super.getCollection(this.addHrefBase(query));
    }

    @Override
    @RequestMapping(value={"/{item}"})
    public ModelAndView getItem(@PathVariable(value="item") String id, @RequestParam MultiValueMap<String, String> query) {
        return super.getItem(id, this.addHrefBase(query));
    }

    @Override
    @RequestMapping(value={"/{item}"}, params={"rawFormat"})
    public void getRawData(HttpServletResponse response, @PathVariable(value="item") String id, @RequestParam MultiValueMap<String, String> query) {
        super.getRawData(response, id, this.addHrefBase(query));
    }

    @Override
    @RequestMapping(value={"/{item}/extras"})
    public Map<String, Object> getExtras(@PathVariable(value="item") String resourceId, @RequestParam(required=false) MultiValueMap<String, String> query) {
        return super.getExtras(resourceId, this.addHrefBase(query));
    }

    protected MultiValueMap<String, String> addHrefBase(MultiValueMap<String, String> query) {
        String externalUrl = this.getExternalUrl();
        String hrefBase = RequestUtils.resolveQueryLessRequestUrl(externalUrl);
        query.put((Object)"internal.href.base", Collections.singletonList(hrefBase));
        return query;
    }
}

