/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import org.n52.io.request.IoParameters;
import org.n52.io.request.QueryParameters;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.StationOutput;
import org.n52.series.spi.geo.TransformingStationOutputService;
import org.n52.series.spi.srv.LocaleAwareSortService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.common.Stopwatch;
import org.n52.web.exception.ResourceNotFoundException;
import org.n52.web.exception.WebExceptionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Deprecated
@RestController
@RequestMapping(value={"/v1/stations"}, produces={"application/json"})
public class StationsParameterController {
    private static final Logger LOGGER = LoggerFactory.getLogger(StationsParameterController.class);
    private ParameterService<StationOutput> parameterService;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getCollection(@RequestParam(required=false) MultiValueMap<String, String> query) {
        IoParameters map = QueryParameters.createFromQuery(query);
        if ((map = IoParameters.ensureBackwardsCompatibility((IoParameters)map)).isExpanded()) {
            Stopwatch stopwatch = Stopwatch.startStopwatch();
            OutputCollection result = this.parameterService.getExpandedParameters(map);
            this.logRequestTime(stopwatch);
            return new ModelAndView().addObject((Object)result.getItems());
        }
        Stopwatch stopwatch = Stopwatch.startStopwatch();
        OutputCollection result = this.parameterService.getCondensedParameters(map);
        this.logRequestTime(stopwatch);
        return new ModelAndView().addObject((Object)result.getItems());
    }

    @RequestMapping(value={"/{item}"}, method={RequestMethod.GET})
    public ModelAndView getItem(@PathVariable(value="item") String procedureId, @RequestParam(required=false) MultiValueMap<String, String> query) {
        IoParameters map = QueryParameters.createFromQuery(query);
        map = IoParameters.ensureBackwardsCompatibility((IoParameters)map);
        Stopwatch stopwatch = Stopwatch.startStopwatch();
        ParameterOutput result = this.parameterService.getParameter(procedureId, map);
        this.logRequestTime(stopwatch);
        if (result == null) {
            throw new ResourceNotFoundException("Found no station with given id.");
        }
        return new ModelAndView().addObject((Object)result);
    }

    public ParameterService<StationOutput> getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService<StationOutput> stationParameterService) {
        TransformingStationOutputService service = new TransformingStationOutputService(stationParameterService);
        this.parameterService = new LocaleAwareSortService(new WebExceptionAdapter(service));
    }

    private void logRequestTime(Stopwatch stopwatch) {
        LOGGER.debug("Processing request took {} seconds.", (Object)stopwatch.stopInSeconds());
    }
}

