/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.n52.io.DatasetFactoryException;
import org.n52.io.DefaultIoFactory;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.IoFactory;
import org.n52.io.MimeType;
import org.n52.io.PreRenderingJob;
import org.n52.io.measurement.format.FormatterFactory;
import org.n52.io.measurement.generalize.GeneralizingMeasurementService;
import org.n52.io.request.IoParameters;
import org.n52.io.request.QueryParameters;
import org.n52.io.request.RequestParameterSet;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.request.RequestStyledParameterSet;
import org.n52.io.response.dataset.DataCollection;
import org.n52.io.response.dataset.measurement.MeasurementData;
import org.n52.io.response.dataset.measurement.MeasurementDatasetOutput;
import org.n52.io.response.dataset.measurement.MeasurementValue;
import org.n52.series.spi.srv.DataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.series.spi.srv.RawDataService;
import org.n52.web.common.Stopwatch;
import org.n52.web.ctrl.BaseController;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.n52.web.exception.WebExceptionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Deprecated
@RestController
@RequestMapping(value={"/v1/timeseries"}, produces={"application/json"})
public class TimeseriesDataController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeseriesDataController.class);
    private ParameterService<MeasurementDatasetOutput> timeseriesMetadataService;
    private DataService<MeasurementData> timeseriesDataService;
    private PreRenderingJob preRenderingTask;
    private String requestIntervalRestriction;

    @RequestMapping(value={"/getData"}, produces={"application/json"}, method={RequestMethod.POST})
    public ModelAndView getTimeseriesCollectionData(HttpServletResponse response, @RequestBody RequestSimpleParameterSet parameters) throws Exception {
        this.checkIfUnknownTimeseries((RequestParameterSet)parameters, parameters.getDatasets());
        if (parameters.isSetRawFormat()) {
            this.getRawTimeseriesCollectionData(response, parameters);
            return null;
        }
        DataCollection<MeasurementData> seriesData = this.getTimeseriesData(parameters);
        DataCollection<?> formattedDataCollection = this.format(seriesData, parameters.getFormat());
        return new ModelAndView().addObject((Object)formattedDataCollection.getAllSeries());
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView getTimeseriesData(HttpServletResponse response, @PathVariable String timeseriesId, @RequestParam(required=false) MultiValueMap<String, String> query) {
        IoParameters map = QueryParameters.createFromQuery(query);
        this.checkIfUnknownTimeseries(map, timeseriesId);
        IntervalWithTimeZone timespan = map.getTimespan();
        this.checkAgainstTimespanRestriction(timespan.toString());
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)timeseriesId, (IoParameters)map);
        if (map.getResultTime() != null) {
            parameters.setResultTime(map.getResultTime().toString());
        }
        parameters.setGeneralize(map.isGeneralize());
        parameters.setExpanded(map.isExpanded());
        DataCollection<MeasurementData> seriesData = this.getTimeseriesData(parameters);
        DataCollection<?> formattedDataCollection = this.format(seriesData, map.getFormat());
        if (map.isExpanded()) {
            return new ModelAndView().addObject((Object)formattedDataCollection.getAllSeries());
        }
        Object formattedTimeseries = formattedDataCollection.getAllSeries().get(timeseriesId);
        return new ModelAndView().addObject(formattedTimeseries);
    }

    @RequestMapping(value={"/getData"}, method={RequestMethod.POST}, params={"rawFormat"})
    public void getRawTimeseriesCollectionData(HttpServletResponse response, @RequestBody RequestSimpleParameterSet parameters) throws Exception {
        this.checkIfUnknownTimeseries((RequestParameterSet)parameters, parameters.getDatasets());
        this.processRawDataRequest(response, parameters);
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, method={RequestMethod.GET}, params={"rawFormat"})
    public void getRawTimeseriesData(HttpServletResponse response, @PathVariable String timeseriesId, @RequestParam MultiValueMap<String, String> query) {
        IoParameters map = QueryParameters.createFromQuery(query);
        this.checkIfUnknownTimeseries(map, timeseriesId);
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)timeseriesId, (IoParameters)map);
        this.processRawDataRequest(response, parameters);
    }

    private void processRawDataRequest(HttpServletResponse response, RequestSimpleParameterSet parameters) {
        if (!this.timeseriesDataService.supportsRawData()) {
            this.throwNewRawDataQueryNotSupportedException();
        }
        RawDataService rawDataService = this.timeseriesDataService.getRawDataService();
        try (InputStream inputStream = rawDataService.getRawData(parameters);){
            if (inputStream == null) {
                throw new ResourceNotFoundException("No raw data found.");
            }
            response.setContentType(parameters.getFormat());
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new InternalServerException("Error while querying raw data", e);
        }
    }

    private DataCollection<?> format(DataCollection<MeasurementData> timeseriesData, String format) {
        return FormatterFactory.createFormatterFactory((String)format).create().format(timeseriesData);
    }

    @RequestMapping(value={"/getData"}, produces={"application/pdf"}, method={RequestMethod.POST})
    public void getTimeseriesCollectionReport(HttpServletResponse response, @RequestBody RequestStyledParameterSet requestParameters) throws Exception {
        IoParameters map = QueryParameters.createFromQuery((RequestParameterSet)requestParameters);
        this.checkIfUnknownTimeseries(map, requestParameters.getDatasets());
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createFromDesignedParameters((RequestStyledParameterSet)requestParameters);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        parameters.setGeneralize(map.isGeneralize());
        parameters.setExpanded(map.isExpanded());
        response.setContentType(MimeType.APPLICATION_PDF.getMimeType());
        this.createIoFactory(parameters).withStyledRequest(requestParameters).createHandler(MimeType.APPLICATION_PDF.getMimeType()).writeBinary((OutputStream)response.getOutputStream());
    }

    private IoFactory<MeasurementData, MeasurementDatasetOutput, MeasurementValue> createIoFactory(RequestSimpleParameterSet parameters) throws DatasetFactoryException, URISyntaxException, MalformedURLException {
        return ((IoFactory)new DefaultIoFactory().create("measurement")).withSimpleRequest(parameters).withBasePath(this.getRootResource()).withDataService(this.timeseriesDataService).withDatasetService(this.timeseriesMetadataService);
    }

    private URI getRootResource() throws URISyntaxException, MalformedURLException {
        return this.getServletConfig().getServletContext().getResource("/").toURI();
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, produces={"application/pdf"}, method={RequestMethod.GET})
    public void getTimeseriesReport(HttpServletResponse response, @PathVariable String timeseriesId, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters map = QueryParameters.createFromQuery(query);
        this.checkIfUnknownTimeseries(map, timeseriesId);
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)timeseriesId, (IoParameters)map);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        parameters.setGeneralize(map.isGeneralize());
        parameters.setExpanded(map.isExpanded());
        response.setContentType(MimeType.APPLICATION_PDF.getMimeType());
        this.createIoFactory(parameters).createHandler(MimeType.APPLICATION_PDF.getMimeType()).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, produces={"application/zip"}, method={RequestMethod.GET})
    public void getTimeseriesAsZippedCsv(HttpServletResponse response, @PathVariable String timeseriesId, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        query.put((Object)MimeType.APPLICATION_ZIP.name(), Arrays.asList(Boolean.TRUE.toString()));
        response.setContentType(MimeType.APPLICATION_ZIP.getMimeType());
        this.getTimeseriesAsCsv(response, timeseriesId, query);
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, produces={"text/csv"}, method={RequestMethod.GET})
    public void getTimeseriesAsCsv(HttpServletResponse response, @PathVariable String timeseriesId, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters map = QueryParameters.createFromQuery(query);
        this.checkIfUnknownTimeseries(map, timeseriesId);
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)timeseriesId, (IoParameters)map);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        parameters.setGeneralize(map.isGeneralize());
        parameters.setExpanded(map.isExpanded());
        response.setCharacterEncoding("UTF-8");
        if (Boolean.parseBoolean(map.getOther(MimeType.APPLICATION_ZIP.name()))) {
            response.setContentType(MimeType.APPLICATION_ZIP.toString());
        } else {
            response.setContentType(MimeType.TEXT_CSV.toString());
        }
        this.createIoFactory(parameters).createHandler("text/csv").writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/getData"}, produces={"image/png"}, method={RequestMethod.POST})
    public void getTimeseriesCollectionChart(HttpServletResponse response, @RequestBody RequestStyledParameterSet requestParameters) throws Exception {
        IoParameters map = QueryParameters.createFromQuery((RequestParameterSet)requestParameters);
        this.checkIfUnknownTimeseries(map, requestParameters.getDatasets());
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createFromDesignedParameters((RequestStyledParameterSet)requestParameters);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        parameters.setGeneralize(map.isGeneralize());
        parameters.setExpanded(map.isExpanded());
        parameters.setBase64(map.isBase64());
        response.setContentType(MimeType.IMAGE_PNG.getMimeType());
        this.createIoFactory(parameters).withStyledRequest(requestParameters).createHandler(MimeType.IMAGE_PNG.toString()).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getTimeseriesChart(HttpServletResponse response, @PathVariable String timeseriesId, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters map = QueryParameters.createFromQuery(query);
        this.checkIfUnknownTimeseries(map, timeseriesId);
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)timeseriesId, (IoParameters)map);
        RequestStyledParameterSet styledParameters = map.toRequestStyledParameterSet();
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        parameters.setGeneralize(map.isGeneralize());
        parameters.setBase64(map.isBase64());
        parameters.setExpanded(map.isExpanded());
        response.setContentType(MimeType.IMAGE_PNG.getMimeType());
        this.createIoFactory(parameters).withStyledRequest(styledParameters).createHandler(MimeType.IMAGE_PNG.toString()).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{timeseriesId}/{chartQualifier}"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getTimeseriesChartByInterval(HttpServletResponse response, @PathVariable String seriesId, @PathVariable String chartQualifier, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        if (this.preRenderingTask == null) {
            throw new ResourceNotFoundException("Diagram prerendering is not enabled.");
        }
        if (!this.preRenderingTask.hasPrerenderedImage(seriesId, chartQualifier)) {
            throw new ResourceNotFoundException("No pre-rendered chart found for timeseries '" + seriesId + "'.");
        }
        this.preRenderingTask.writePrerenderedGraphToOutputStream(seriesId, chartQualifier, (OutputStream)response.getOutputStream());
    }

    private void checkAgainstTimespanRestriction(String timespan) {
        Duration duration = Period.parse((String)this.requestIntervalRestriction).toDurationFrom((ReadableInstant)new DateTime());
        if (duration.getMillis() < Interval.parse((String)timespan).toDurationMillis()) {
            throw new BadRequestException("Requested timespan is to long, please use a period shorter than '" + this.requestIntervalRestriction + "'");
        }
    }

    private void checkIfUnknownTimeseries(RequestParameterSet parameters, String ... timeseriesIds) {
        this.checkIfUnknownTimeseries(IoParameters.createFromQuery((RequestParameterSet)parameters), timeseriesIds);
    }

    private void checkIfUnknownTimeseries(IoParameters parameters, String ... timeseriesIds) {
        for (String timeseriesId : timeseriesIds) {
            if (this.timeseriesMetadataService.exists(timeseriesId, parameters)) continue;
            throw new ResourceNotFoundException("The timeseries with id '" + timeseriesId + "' was not found.");
        }
    }

    private DataCollection<MeasurementData> getTimeseriesData(RequestSimpleParameterSet parameters) {
        Stopwatch stopwatch = Stopwatch.startStopwatch();
        DataCollection timeseriesData = parameters.isGeneralize() ? new GeneralizingMeasurementService(this.timeseriesDataService).getData((RequestParameterSet)parameters) : this.timeseriesDataService.getData((RequestParameterSet)parameters);
        LOGGER.debug("Processing request took {} seconds.", (Object)stopwatch.stopInSeconds());
        return timeseriesData;
    }

    public ParameterService<MeasurementDatasetOutput> getTimeseriesMetadataService() {
        return this.timeseriesMetadataService;
    }

    public void setTimeseriesMetadataService(ParameterService<MeasurementDatasetOutput> timeseriesMetadataService) {
        this.timeseriesMetadataService = new WebExceptionAdapter<MeasurementDatasetOutput>(timeseriesMetadataService);
    }

    public DataService<MeasurementData> getTimeseriesDataService() {
        return this.timeseriesDataService;
    }

    public void setTimeseriesDataService(DataService<MeasurementData> timeseriesDataService) {
        this.timeseriesDataService = timeseriesDataService;
    }

    public PreRenderingJob getPreRenderingTask() {
        return this.preRenderingTask;
    }

    public void setPreRenderingTask(PreRenderingJob prerenderingTask) {
        this.preRenderingTask = prerenderingTask;
    }

    public String getRequestIntervalRestriction() {
        return this.requestIntervalRestriction;
    }

    public void setRequestIntervalRestriction(String requestIntervalRestriction) {
        Period.parse((String)requestIntervalRestriction);
        this.requestIntervalRestriction = requestIntervalRestriction;
    }

    private void throwNewRawDataQueryNotSupportedException() {
        throw new BadRequestException("Querying of raw procedure data is not supported by the underlying service!");
    }
}

