/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import java.util.Map;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.IoParseException;
import org.n52.io.crs.BoundingBox;
import org.n52.io.request.IoParameters;
import org.n52.io.request.StyleProperties;
import org.n52.web.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class QueryParameters
extends IoParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryParameters.class);

    private QueryParameters(MultiValueMap<String, String> query) {
        super(QueryParameters.convertValuesToJsonNodes(query));
    }

    private QueryParameters(Map<String, String> query) {
        super(QueryParameters.convertValuesToJsonNodes(query));
    }

    public StyleProperties getStyle() {
        try {
            return super.getStyle();
        }
        catch (IoParseException e) {
            throw new BadRequestException("Could not read 'style' property.", e);
        }
    }

    public IntervalWithTimeZone getTimespan() {
        try {
            return super.getTimespan();
        }
        catch (IoParseException e) {
            BadRequestException badRequest = new BadRequestException("Invalid timespan.", e);
            badRequest.addHint("Valid timespans have to be in ISO8601 period format.");
            badRequest.addHint("Valid examples: 'PT6H/2013-08-13TZ' or '2013-07-13TZ/2013-08-13TZ'.");
            throw badRequest;
        }
    }

    public BoundingBox getSpatialFilter() {
        try {
            return super.getSpatialFilter();
        }
        catch (IoParseException e) {
            BadRequestException ex = new BadRequestException("Spatial filter could not be determined.", e);
            ex.addHint("Refer to the API documentation and check the parameter against required syntax!");
            ex.addHint("Check http://epsg-registry.org for EPSG CRS definitions and codes.");
            throw ex;
        }
    }

    public static IoParameters createFromQuery(Map<String, String> query) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.setAll(query);
        return QueryParameters.createFromQuery((MultiValueMap<String, String>)parameters);
    }

    public static IoParameters createFromQuery(MultiValueMap<String, String> query) {
        return IoParameters.createFromMultiValueMap(query);
    }

    private void throwBadParameterException(String parameter, Exception e) {
        throw new BadRequestException("Bad '" + parameter + "' parameter.", e);
    }
}

