/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.io.MimeType;
import org.n52.web.ctrl.ResourcesController;
import org.n52.web.exception.BadQueryParameterException;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.ExceptionResponse;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.n52.web.exception.WebException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.ServletConfigAware;

@RestController
public abstract class BaseController
implements ServletConfigAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourcesController.class);
    private static final String HEADER_ACCEPT = "Accept";
    private ServletConfig servletConfig;

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    protected boolean isRequestingJsonData(HttpServletRequest request) {
        return MimeType.APPLICATION_JSON.getMimeType().equals(BaseController.getAcceptHeader(request));
    }

    protected boolean isRequestingPdfData(HttpServletRequest request) {
        return MimeType.APPLICATION_PDF.getMimeType().equals(BaseController.getAcceptHeader(request));
    }

    protected boolean isRequestingPngData(HttpServletRequest request) {
        return MimeType.IMAGE_PNG.getMimeType().equals(BaseController.getAcceptHeader(request));
    }

    private static String getAcceptHeader(HttpServletRequest request) {
        return request.getHeader(HEADER_ACCEPT);
    }

    @ExceptionHandler(value={BadRequestException.class, BadQueryParameterException.class})
    public void handle400(Exception e, HttpServletRequest request, HttpServletResponse response) {
        this.writeExceptionResponse((WebException)((Object)e), response, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public void handle404(Exception e, HttpServletRequest request, HttpServletResponse response) {
        this.writeExceptionResponse((WebException)((Object)e), response, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InternalServerException.class})
    public void handle500(Exception e, HttpServletRequest request, HttpServletResponse response) {
        this.writeExceptionResponse((WebException)((Object)e), response, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={RuntimeException.class, Exception.class, Throwable.class})
    public void handleException(Exception e, HttpServletRequest request, HttpServletResponse response) {
        if (e instanceof HttpMessageNotReadableException) {
            BadRequestException wrappedException = new BadRequestException("The request could not been read.", e);
            wrappedException.addHint("Check the message which has been sent to the server. Probably it is not valid.");
            this.writeExceptionResponse(wrappedException, response, HttpStatus.BAD_REQUEST);
        } else {
            InternalServerException wrappedException = new InternalServerException("Unexpected Exception occured.", e);
            this.writeExceptionResponse(wrappedException, response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void writeExceptionResponse(WebException e, HttpServletResponse response, HttpStatus status) {
        String logMessage = "An exception occured.";
        if (status == HttpStatus.INTERNAL_SERVER_ERROR) {
            LOGGER.error("An exception occured.", (Object)e);
        } else {
            LOGGER.debug("An exception occured.", (Object)e);
        }
        response.setStatus(status.value());
        response.setContentType(MimeType.APPLICATION_JSON.getMimeType());
        ObjectMapper objectMapper = this.createObjectMapper();
        ObjectWriter writer = objectMapper.writerFor(ExceptionResponse.class);
        ExceptionResponse exceptionResponse = ExceptionResponse.createExceptionResponse(e, status);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            writer.writeValue((OutputStream)outputStream, (Object)exceptionResponse);
        }
        catch (IOException ioe) {
            LOGGER.error("Could not process error message.", (Throwable)ioe);
        }
    }

    protected ObjectMapper createObjectMapper() {
        return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

