/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.exception;

import java.io.InputStream;
import org.n52.io.request.IoParameters;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.ParameterOutput;
import org.n52.series.spi.srv.ParameterService;
import org.n52.series.spi.srv.RawDataService;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;

public class WebExceptionAdapter<T extends ParameterOutput>
extends ParameterService<T>
implements RawDataService {
    private final ParameterService<T> composedService;

    public WebExceptionAdapter(ParameterService<T> toCompose) {
        this.composedService = toCompose;
    }

    public OutputCollection<T> getExpandedParameters(IoParameters query) {
        OutputCollection parameters = this.composedService.getExpandedParameters(query);
        this.assertValidSpiImplementation(parameters);
        return parameters;
    }

    public OutputCollection<T> getCondensedParameters(IoParameters query) {
        OutputCollection parameters = this.composedService.getCondensedParameters(query);
        this.assertValidSpiImplementation(parameters);
        return parameters;
    }

    public OutputCollection<T> getParameters(String[] items, IoParameters query) {
        OutputCollection parameters = this.composedService.getParameters(items, query);
        this.assertValidSpiImplementation(parameters);
        return parameters;
    }

    public T getParameter(String item, IoParameters query) {
        this.assertItemExists(item, query);
        return (T)this.composedService.getParameter(item, query);
    }

    private void assertItemExists(String item, IoParameters parameters) {
        if (!this.exists(item, parameters)) {
            throw new ResourceNotFoundException("Resource with id '" + item + "' was not found.");
        }
    }

    public boolean exists(String id, IoParameters parameters) {
        return this.composedService.exists(id, parameters);
    }

    public InputStream getRawData(String id, IoParameters query) {
        if (this.composedService.supportsRawData()) {
            return this.composedService.getRawDataService().getRawData(id, query);
        }
        return null;
    }

    public InputStream getRawData(RequestSimpleParameterSet parameters) {
        if (this.composedService.supportsRawData()) {
            return this.composedService.getRawDataService().getRawData(parameters);
        }
        return null;
    }

    public RawDataService getRawDataService() {
        return this.composedService.getRawDataService();
    }

    public boolean supportsRawData() {
        return this.composedService.supportsRawData();
    }

    private void assertValidSpiImplementation(OutputCollection<T> parameters) throws InternalServerException {
        if (parameters == null) {
            throw new InternalServerException("SPI implementation did return null value!");
        }
    }
}

