/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.n52.io.DatasetFactoryException;
import org.n52.io.DefaultIoFactory;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.IoFactory;
import org.n52.io.IoHandlerException;
import org.n52.io.IoStyleContext;
import org.n52.io.PrerenderingJobConfig;
import org.n52.io.quantity.img.ChartDimension;
import org.n52.io.request.IoParameters;
import org.n52.io.request.QueryParameters;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.request.RequestStyledParameterSet;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.task.ScheduledJob;
import org.n52.series.spi.srv.DataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.common.Stopwatch;
import org.n52.web.exception.ResourceNotFoundException;
import org.quartz.InterruptableJob;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.ServletConfigAware;

public class PreRenderingJob
extends ScheduledJob
implements InterruptableJob,
ServletConfigAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreRenderingJob.class);
    private static final int WIDTH_DEFAULT = 800;
    private static final int HEIGHT_DEFAULT = 500;
    private static final String LANGUAGE_DEFAULT = "en";
    private static final boolean GRID_DEFAULT = true;
    private static final boolean LEGEND_DEFAULT = false;
    private static final boolean GENERALIZE_DEFAULT = false;
    private static final String JOB_DATA_CONFIG_FILE = "configFile";
    private static final String JOB_DATA_WEBAPP_FOLDER = "webappFolder";
    private static final String IMAGE_EXTENSION = "png";
    @Autowired
    @Qualifier(value="datasetService")
    private ParameterService<DatasetOutput<AbstractValue<?>, ?>> datasetService;
    @Autowired
    @Qualifier(value="datasetService")
    private DataService<Data<AbstractValue<?>>> dataService;
    private PrerenderingJobConfig taskConfigPrerendering;
    private String webappFolder;
    private String configFile;
    private boolean interrupted;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrerenderingJobConfig readJobConfig(String file) {
        try (InputStream taskConfig = ((Object)((Object)this)).getClass().getResourceAsStream(file);){
            ObjectMapper om = new ObjectMapper();
            PrerenderingJobConfig prerenderingJobConfig = (PrerenderingJobConfig)om.readValue(taskConfig, PrerenderingJobConfig.class);
            return prerenderingJobConfig;
        }
        catch (IOException e) {
            LOGGER.error("Could not load {}. Using empty config.", (Object)file, (Object)e);
            return new PrerenderingJobConfig();
        }
    }

    public JobDetail createJobDetails() {
        return JobBuilder.newJob(PreRenderingJob.class).withIdentity(this.getJobName()).withDescription(this.getJobDescription()).usingJobData(JOB_DATA_CONFIG_FILE, this.configFile).usingJobData(JOB_DATA_WEBAPP_FOLDER, this.webappFolder).build();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (this.interrupted) {
            return;
        }
        LOGGER.info("Start prerendering task");
        Stopwatch stopwatch = Stopwatch.startStopwatch();
        JobDetail details = context.getJobDetail();
        JobDataMap jobDataMap = details.getJobDataMap();
        this.taskConfigPrerendering = this.readJobConfig(jobDataMap.getString(JOB_DATA_CONFIG_FILE));
        this.webappFolder = jobDataMap.getString(JOB_DATA_WEBAPP_FOLDER);
        List<PrerenderingJobConfig.RenderingConfig> phenomenonStyles = this.taskConfigPrerendering.getPhenomenonStyles();
        List<PrerenderingJobConfig.RenderingConfig> styles = this.taskConfigPrerendering.getSeriesStyles();
        for (PrerenderingJobConfig.RenderingConfig config : phenomenonStyles) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("phenomenon", config.getId());
            IoParameters query = QueryParameters.createFromQuery(parameters);
            for (DatasetOutput metadata : this.datasetService.getCondensedParameters(query)) {
                String timeseriesId = metadata.getId();
                this.renderConfiguredIntervals(timeseriesId, config);
                if (!this.interrupted) continue;
                return;
            }
        }
        for (PrerenderingJobConfig.RenderingConfig config : styles) {
            this.renderConfiguredIntervals(config.getId(), config);
            if (!this.interrupted) continue;
            return;
        }
        LOGGER.debug("prerendering took '{}'", (Object)stopwatch.stopInSeconds());
    }

    private void renderConfiguredIntervals(String datasetId, PrerenderingJobConfig.RenderingConfig style) {
        try {
            for (String interval : style.getInterval()) {
                this.renderWithStyle(datasetId, style, interval);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error occured while prerendering timeseries {}.", (Object)datasetId, (Object)e);
        }
    }

    private void renderWithStyle(String datasetId, PrerenderingJobConfig.RenderingConfig renderingConfig, String interval) throws IOException, DatasetFactoryException, URISyntaxException {
        IntervalWithTimeZone timespan = this.createTimespanFromInterval(datasetId, interval);
        IoParameters config = this.createConfig(timespan.toString(), renderingConfig);
        DatasetOutput metadata = (DatasetOutput)this.datasetService.getParameter(datasetId, config);
        IoStyleContext context = IoStyleContext.createContextForSingleSeries((DatasetOutput)metadata, (IoParameters)config);
        RequestStyledParameterSet styleDefinition = context.getChartStyleDefinitions();
        context.setDimensions(new ChartDimension(styleDefinition.getWidth(), styleDefinition.getHeight()));
        RequestSimpleParameterSet parameters = RequestSimpleParameterSet.createForSingleSeries((String)datasetId, (IoParameters)config);
        String chartQualifier = renderingConfig.getChartQualifier();
        FileOutputStream fos = this.createFile(datasetId, interval, chartQualifier);
        try (FileOutputStream out = fos;){
            this.createIoFactory(parameters).createHandler(IMAGE_EXTENSION).writeBinary((OutputStream)out);
            fos.flush();
        }
        catch (IOException | IoHandlerException e) {
            LOGGER.error("Image creation occures error.", e);
        }
    }

    private IoFactory<Data<AbstractValue<?>>, DatasetOutput<AbstractValue<?>, ?>, AbstractValue<?>> createIoFactory(RequestSimpleParameterSet parameters) throws DatasetFactoryException, URISyntaxException, MalformedURLException {
        return ((IoFactory)this.createDefaultIoFactory().create("quantity")).withSimpleRequest(parameters).withDataService(this.dataService).withDatasetService(this.datasetService);
    }

    private DefaultIoFactory<Data<AbstractValue<?>>, DatasetOutput<AbstractValue<?>, ?>, AbstractValue<?>> createDefaultIoFactory() {
        return new DefaultIoFactory();
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.interrupted = true;
        LOGGER.info("Marked job to interrupt.");
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.webappFolder = servletConfig.getServletContext().getRealPath("/");
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public List<String> getPrerenderedImages(final String datasetId) {
        FilenameFilter startsWithIdFilter;
        String[] filtered;
        if (this.taskConfigPrerendering == null) {
            this.taskConfigPrerendering = this.readJobConfig(this.configFile);
        }
        Path outputPath = this.getOutputFolder();
        ArrayList<String> files = new ArrayList<String>();
        File outputDir = outputPath.toFile();
        if (outputDir.isDirectory() && (filtered = outputDir.list(startsWithIdFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(datasetId);
            }
        })) != null) {
            files.addAll(Arrays.asList(filtered));
        }
        return files;
    }

    public boolean hasPrerenderedImage(String fileName) {
        return this.hasPrerenderedImage(fileName, null);
    }

    public boolean hasPrerenderedImage(String datasetId, String chartQualifier) {
        return this.createFileName(datasetId, chartQualifier).exists();
    }

    public void writePrerenderedGraphToOutputStream(String filename, OutputStream outputStream) {
        this.writePrerenderedGraphToOutputStream(filename, null, outputStream);
    }

    public void writePrerenderedGraphToOutputStream(String datasetId, String qualifier, OutputStream outputStream) {
        if (this.taskConfigPrerendering == null) {
            this.taskConfigPrerendering = this.readJobConfig(this.configFile);
        }
        try {
            BufferedImage image = this.loadImage(datasetId, qualifier);
            if (image == null) {
                ResourceNotFoundException ex = new ResourceNotFoundException("Could not find image on server.");
                ex.addHint("Perhaps the image is being rendered at the moment. Try again later.");
                throw ex;
            }
            LOGGER.debug("write prerendered image '{}'", (Object)this.createFileName(datasetId, qualifier));
            ImageIO.write((RenderedImage)image, IMAGE_EXTENSION, outputStream);
        }
        catch (IOException e) {
            LOGGER.error("Error while loading pre rendered image", (Throwable)e);
        }
    }

    private BufferedImage loadImage(String datasetId, String qualifier) throws IOException {
        return ImageIO.read(new FileInputStream(this.createFileName(datasetId, qualifier)));
    }

    private IntervalWithTimeZone createTimespanFromInterval(String datasetId, String period) {
        DateTime now = new DateTime();
        if (period.equals("lastDay")) {
            Interval interval = new Interval((ReadableInstant)now.minusDays(1), (ReadableInstant)now);
            return new IntervalWithTimeZone(interval.toString());
        }
        if (period.equals("lastWeek")) {
            Interval interval = new Interval((ReadableInstant)now.minusWeeks(1), (ReadableInstant)now);
            return new IntervalWithTimeZone(interval.toString());
        }
        if (period.equals("lastMonth")) {
            Interval interval = new Interval((ReadableInstant)now.minusMonths(1), (ReadableInstant)now);
            return new IntervalWithTimeZone(interval.toString());
        }
        throw new ResourceNotFoundException("Unknown interval '" + period + "' for datatset " + datasetId);
    }

    private FileOutputStream createFile(String datasetId, String interval, String postfix) throws IOException {
        String chartQualifier = postfix != null ? interval + "_" + postfix : interval;
        File file = this.createFileName(datasetId, chartQualifier);
        if (!file.exists() && !file.createNewFile()) {
            LOGGER.warn("Can't create file '{}'", (Object)file.getAbsolutePath());
        }
        if (!file.setLastModified(new Date().getTime())) {
            LOGGER.debug("Can't set last modified date at '{}'", (Object)file.getAbsolutePath());
        }
        return new FileOutputStream(file);
    }

    private File createFileName(String datasetId, String qualifier) {
        if (this.taskConfigPrerendering == null) {
            this.taskConfigPrerendering = this.readJobConfig(this.configFile);
        }
        Path outputDirectory = this.getOutputFolder();
        String filename = qualifier != null ? datasetId + "_" + qualifier : datasetId;
        return outputDirectory.resolve(filename + ".png").toFile();
    }

    private Path getOutputFolder() {
        Map<String, String> generalConfig = this.taskConfigPrerendering.getGeneralConfig();
        String outputPath = generalConfig.get("outputPath");
        Path outputDirectory = Paths.get(this.webappFolder, new String[0]).resolve(outputPath);
        File dir = outputDirectory.toFile();
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.warn("Unable to create output folder '{}'.", (Object)outputDirectory);
        }
        return outputDirectory;
    }

    private IoParameters createConfig(String interval, PrerenderingJobConfig.RenderingConfig renderingConfig) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("width", Integer.toString(800));
        configuration.put("height", Integer.toString(500));
        configuration.put("grid", Boolean.toString(true));
        configuration.put("legend", Boolean.toString(false));
        configuration.put("generalize", Boolean.toString(false));
        configuration.put("locale", LANGUAGE_DEFAULT);
        configuration.put("timespan", interval);
        configuration.putAll(this.taskConfigPrerendering.getGeneralConfig());
        if (renderingConfig.getConfig() != null) {
            configuration.putAll(renderingConfig.getConfig());
        }
        configuration.put("rendering_trigger", "prerendering");
        try {
            ObjectMapper om = new ObjectMapper();
            configuration.put("style", om.writeValueAsString((Object)renderingConfig.getStyle()));
            configuration.put("title", renderingConfig.getTitle());
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Invalid rendering style.", (Throwable)e);
        }
        return QueryParameters.createFromQuery(configuration);
    }
}

