/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.extension;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.n52.io.extension.RenderingHintsExtensionConfig;
import org.n52.io.request.IoParameters;
import org.n52.io.request.StyleProperties;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.TimeseriesMetadataOutput;
import org.n52.io.response.extension.MetadataExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderingHintsExtension
extends MetadataExtension<DatasetOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderingHintsExtension.class);
    private static final String CONFIG_FILE = "/config-rendering-hints.json";
    private static final String EXTENSION_NAME = "renderingHints";
    private final RenderingHintsExtensionConfig renderingConfig = this.readConfig();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RenderingHintsExtensionConfig readConfig() {
        try (InputStream config = ((Object)((Object)this)).getClass().getResourceAsStream(CONFIG_FILE);){
            ObjectMapper om = new ObjectMapper();
            RenderingHintsExtensionConfig renderingHintsExtensionConfig = (RenderingHintsExtensionConfig)om.readValue(config, RenderingHintsExtensionConfig.class);
            return renderingHintsExtensionConfig;
        }
        catch (IOException e) {
            LOGGER.error("Could not load {}. Using empty config.", (Object)CONFIG_FILE, (Object)e);
            return new RenderingHintsExtensionConfig();
        }
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public void addExtraMetadataFieldNames(DatasetOutput output) {
        if (this.hasRenderingHints(output)) {
            output.addExtra(EXTENSION_NAME);
        }
    }

    private boolean hasRenderingHints(DatasetOutput output) {
        return this.hasSeriesConfiguration(output) || this.hasPhenomenonConfiguration(output);
    }

    private boolean hasSeriesConfiguration(DatasetOutput output) {
        return this.renderingConfig.getTimeseriesStyles().containsKey(output.getId());
    }

    private boolean hasPhenomenonConfiguration(DatasetOutput output) {
        String id = output.getSeriesParameters().getPhenomenon().getId();
        return this.renderingConfig.getPhenomenonStyles().containsKey(id);
    }

    public Map<String, Object> getExtras(DatasetOutput output, IoParameters parameters) {
        if (!this.hasExtrasToReturn(output, parameters)) {
            return Collections.emptyMap();
        }
        if (this.hasSeriesConfiguration(output)) {
            StyleProperties style = this.createStyle(this.getSeriesStyle(output));
            this.checkForBackwardCompatiblity(output, style);
            return this.wrapSingleIntoMap(style);
        }
        if (this.hasPhenomenonConfiguration(output)) {
            StyleProperties style = this.createStyle(this.getPhenomenonStyle(output));
            this.checkForBackwardCompatiblity(output, style);
            return this.wrapSingleIntoMap(style);
        }
        LOGGER.error("No rendering style found for {} (id={})", (Object)output, (Object)output.getId());
        return Collections.emptyMap();
    }

    private boolean hasExtrasToReturn(DatasetOutput output, IoParameters parameters) {
        return super.hasExtrasToReturn((ParameterOutput)output, parameters) && this.hasRenderingHints(output);
    }

    private RenderingHintsExtensionConfig.ConfiguredStyle getSeriesStyle(DatasetOutput output) {
        return this.renderingConfig.getTimeseriesStyles().get(output.getId());
    }

    private RenderingHintsExtensionConfig.ConfiguredStyle getPhenomenonStyle(DatasetOutput output) {
        String id = output.getSeriesParameters().getPhenomenon().getId();
        return this.renderingConfig.getPhenomenonStyles().get(id);
    }

    private StyleProperties createStyle(RenderingHintsExtensionConfig.ConfiguredStyle configuredStyle) {
        return configuredStyle.getStyle();
    }

    private void checkForBackwardCompatiblity(DatasetOutput output, StyleProperties style) {
        if (output instanceof TimeseriesMetadataOutput) {
            ((TimeseriesMetadataOutput)output).setRenderingHints(style);
        }
    }
}

