/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.n52.io.request.IoParameters;
import org.n52.io.request.QueryParameters;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.extension.MetadataExtension;
import org.n52.series.spi.srv.LocaleAwareSortService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.common.Stopwatch;
import org.n52.web.ctrl.BaseController;
import org.n52.web.ctrl.ResourceController;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.n52.web.exception.WebExceptionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.ModelAndView;

public abstract class ParameterController<T extends ParameterOutput>
extends BaseController
implements ResourceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterController.class);
    private List<MetadataExtension<T>> metadataExtensions = new ArrayList<MetadataExtension<T>>();
    private ParameterService<T> parameterService;
    private String externalUrl;

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(String externalUrl) {
        LOGGER.debug("CONFIG: external.url={}", (Object)externalUrl);
        this.externalUrl = externalUrl;
    }

    @Override
    public void getRawData(HttpServletResponse response, String id, MultiValueMap<String, String> query) {
        if (!this.getParameterService().supportsRawData()) {
            throw new BadRequestException("Querying raw procedure data is not supported!");
        }
        IoParameters queryMap = QueryParameters.createFromQuery(query);
        LOGGER.debug("getRawData() with id '{}' and query '{}'", (Object)id, (Object)queryMap);
        try (InputStream inputStream = this.getParameterService().getRawDataService().getRawData(id, queryMap);){
            if (inputStream == null) {
                throw new ResourceNotFoundException("No raw data found for id '" + id + "'.");
            }
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new InternalServerException("Error while querying raw data", e);
        }
    }

    @Override
    public Map<String, Object> getExtras(String resourceId, MultiValueMap<String, String> query) {
        IoParameters queryMap = QueryParameters.createFromQuery(query);
        LOGGER.debug("getExtras() with id '{}' and query '{}'", (Object)resourceId, (Object)queryMap);
        HashMap<String, Object> extras = new HashMap<String, Object>();
        for (MetadataExtension<T> extension : this.metadataExtensions) {
            ParameterOutput from;
            Map furtherExtras = extension.getExtras(from = this.parameterService.getParameter(resourceId, queryMap), queryMap);
            Collection<String> overridableKeys = this.checkForOverridingData(extras, furtherExtras);
            if (!overridableKeys.isEmpty()) {
                Object[] keys = overridableKeys.toArray(new String[0]);
                LOGGER.warn("Metadata extension overrides existing extra data: {}", (Object)Arrays.toString(keys));
            }
            extras.putAll(furtherExtras);
        }
        return extras;
    }

    private Collection<String> checkForOverridingData(Map<String, Object> data, Map<String, Object> dataToAdd) {
        HashMap<String, Object> currentData = new HashMap<String, Object>(data);
        Set<String> overridableKeys = currentData.keySet();
        overridableKeys.retainAll(dataToAdd.keySet());
        return overridableKeys;
    }

    @Override
    public ModelAndView getCollection(MultiValueMap<String, String> query) {
        IoParameters queryMap = QueryParameters.createFromQuery(query);
        LOGGER.debug("getCollection() with query '{}'", (Object)queryMap);
        if (queryMap.isExpanded()) {
            Stopwatch stopwatch = Stopwatch.startStopwatch();
            OutputCollection result = this.addExtensionInfos((T)this.parameterService.getExpandedParameters(queryMap));
            LOGGER.debug("Processing request took {} seconds.", (Object)stopwatch.stopInSeconds());
            return this.createModelAndView(result);
        }
        OutputCollection results = this.parameterService.getCondensedParameters(queryMap);
        return this.createModelAndView(results);
    }

    @Override
    public ModelAndView getItem(String id, MultiValueMap<String, String> query) {
        IoParameters queryMap = QueryParameters.createFromQuery(query);
        LOGGER.debug("getItem() with id '{}' and query '{}'", (Object)id, (Object)queryMap);
        ParameterOutput item = this.parameterService.getParameter(id, queryMap);
        if (item == null) {
            throw new ResourceNotFoundException("Resource with id '" + id + "' not found.");
        }
        ParameterOutput parameter = this.addExtensionInfos(item);
        return new ModelAndView().addObject((Object)parameter);
    }

    protected OutputCollection<T> addExtensionInfos(OutputCollection<T> toBeProcessed) {
        for (ParameterOutput parameterOutput : toBeProcessed) {
            this.addExtensionInfos(parameterOutput);
        }
        return toBeProcessed;
    }

    protected T addExtensionInfos(T output) {
        for (MetadataExtension<T> extension : this.metadataExtensions) {
            extension.addExtraMetadataFieldNames(output);
        }
        return output;
    }

    protected ModelAndView createModelAndView(OutputCollection<T> items) {
        return new ModelAndView().addObject((Object)items.getItems());
    }

    public ParameterService<T> getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService<T> parameterService) {
        WebExceptionAdapter<T> service = new WebExceptionAdapter<T>(parameterService);
        this.parameterService = new LocaleAwareSortService(service);
    }

    public List<MetadataExtension<T>> getMetadataExtensions() {
        return this.metadataExtensions;
    }

    public void setMetadataExtensions(List<MetadataExtension<T>> metadataExtensions) {
        this.metadataExtensions = metadataExtensions;
    }
}

