/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.common;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.n52.io.request.IoParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtils {
    private static final String REQUEST_URL_FALLBACK = "http://localhost:8080";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtils.class);

    public static IoParameters overrideQueryLocaleWhenSet(String locale, IoParameters query) {
        return locale != null ? query.replaceWith("locale", new String[]{locale}) : query;
    }

    public static String resolveQueryLessRequestUrl(String externalUrl) {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        if (LOGGER.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("\n----- Start of HTTP Header -----\n");
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                sb.append(headerName + ": " + request.getHeader(headerName));
                sb.append("\n");
            }
            sb.append("----- END of HTTP Header -----");
            LOGGER.trace(sb.toString());
        }
        return externalUrl == null || externalUrl.isEmpty() ? RequestUtils.createRequestUrl(request) : RequestUtils.createRequestUrl(externalUrl);
    }

    private static String createRequestUrl(String externalUrl) {
        try {
            String url = new URL(externalUrl).toString();
            return RequestUtils.removeTrailingSlash(url);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Invalid external url setting. Fallback to '{}'", (Object)REQUEST_URL_FALLBACK);
            return REQUEST_URL_FALLBACK;
        }
    }

    private static String createRequestUrl(HttpServletRequest request) {
        try {
            URL url = new URL(request.getRequestURL().toString());
            String scheme = url.getProtocol();
            String userInfo = url.getUserInfo();
            String host = url.getHost();
            int port = url.getPort();
            String path = request.getRequestURI();
            path = RequestUtils.removeTrailingSlash(path);
            URI uri = new URI(scheme, userInfo, host, port, path, null, null);
            String requestUrl = uri.toString();
            LOGGER.debug("Resolved external url '{}'.", (Object)requestUrl);
            return requestUrl;
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOGGER.error("Could not resolve external url. Fallback to '{}'", (Object)REQUEST_URL_FALLBACK);
            return REQUEST_URL_FALLBACK;
        }
    }

    private static String removeTrailingSlash(String path) {
        return path != null && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }
}

