/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.extension;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.n52.io.extension.StatusIntervalsExtensionConfig;
import org.n52.io.request.IoParameters;
import org.n52.io.response.StatusInterval;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.extension.MetadataExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusIntervalsExtension
extends MetadataExtension<DatasetOutput<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusIntervalsExtension.class);
    private static final String CONFIG_FILE = "/config-status-intervals.json";
    private static final String EXTENSION_NAME = "statusIntervals";
    private final StatusIntervalsExtensionConfig intervalConfig = this.readConfig();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StatusIntervalsExtensionConfig readConfig() {
        try (InputStream config = ((Object)((Object)this)).getClass().getResourceAsStream(CONFIG_FILE);){
            ObjectMapper om = new ObjectMapper();
            StatusIntervalsExtensionConfig statusIntervalsExtensionConfig = (StatusIntervalsExtensionConfig)om.readValue(config, StatusIntervalsExtensionConfig.class);
            return statusIntervalsExtensionConfig;
        }
        catch (Exception e) {
            LOGGER.error("Could not load {). Using empty config.", (Object)CONFIG_FILE, (Object)e);
            return new StatusIntervalsExtensionConfig();
        }
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Collection<String> getExtraMetadataFieldNames(DatasetOutput<?> output) {
        return this.hasStatusIntervals(output) ? Collections.singleton(EXTENSION_NAME) : Collections.emptySet();
    }

    private boolean hasStatusIntervals(DatasetOutput<?> output) {
        return this.hasSeriesConfiguration(output) || this.hasPhenomenonConfiguration(output);
    }

    private boolean hasSeriesConfiguration(DatasetOutput<?> output) {
        Map<String, StatusIntervalsExtensionConfig.ConfigInterval> intervals = this.intervalConfig.getTimeseriesIntervals();
        return intervals.containsKey(output.getId());
    }

    private boolean hasPhenomenonConfiguration(DatasetOutput<?> output) {
        Map<String, StatusIntervalsExtensionConfig.ConfigInterval> intervals = this.intervalConfig.getPhenomenonIntervals();
        return intervals.containsKey(output.getId());
    }

    public Map<String, Object> getExtras(DatasetOutput<?> output, IoParameters parameters) {
        if (!this.hasExtrasToReturn(output, parameters)) {
            return Collections.emptyMap();
        }
        if (this.hasSeriesConfiguration(output)) {
            return this.wrapSingleIntoMap(this.createIntervals(this.getSeriesIntervals(output)));
        }
        if (this.hasPhenomenonConfiguration(output)) {
            return this.wrapSingleIntoMap(this.createIntervals(this.getPhenomenonIntervals(output)));
        }
        LOGGER.error("No status intervals found for {} (id={})", output, (Object)output.getId());
        return Collections.emptyMap();
    }

    private boolean hasExtrasToReturn(DatasetOutput<?> output, IoParameters parameters) {
        return super.hasExtrasToReturn(output, parameters) && this.hasStatusIntervals(output);
    }

    private StatusIntervalsExtensionConfig.ConfigInterval getSeriesIntervals(DatasetOutput<?> output) {
        return this.intervalConfig.getTimeseriesIntervals().get(output.getId());
    }

    private StatusIntervalsExtensionConfig.ConfigInterval getPhenomenonIntervals(DatasetOutput<?> output) {
        String id = output.getDatasetParameters(true).getPhenomenon().getId();
        return this.intervalConfig.getPhenomenonIntervals().get(id);
    }

    private Collection<StatusInterval> createIntervals(StatusIntervalsExtensionConfig.ConfigInterval configInterval) {
        Map<String, StatusInterval> statusIntervals = configInterval.getStatusIntervals();
        for (Map.Entry<String, StatusInterval> entry : statusIntervals.entrySet()) {
            StatusInterval value = entry.getValue();
            value.setName(entry.getKey());
        }
        return statusIntervals.values();
    }
}

