/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.util.Collections;
import javax.servlet.http.HttpServletResponse;
import org.n52.io.request.IoParameters;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.dataset.StationOutput;
import org.n52.io.response.pagination.OffsetBasedPagination;
import org.n52.io.response.pagination.Paginated;
import org.n52.io.response.pagination.Pagination;
import org.n52.series.spi.geo.TransformingStationOutputService;
import org.n52.series.spi.srv.CountingMetadataService;
import org.n52.series.spi.srv.LocaleAwareSortService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.common.RequestUtils;
import org.n52.web.common.Stopwatch;
import org.n52.web.ctrl.BaseController;
import org.n52.web.ctrl.ProceduresParameterController;
import org.n52.web.ctrl.UrlHelper;
import org.n52.web.exception.ResourceNotFoundException;
import org.n52.web.exception.SpiAssertionExceptionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Deprecated
@RestController
@RequestMapping(value={"/stations"}, produces={"application/json"})
public class StationsParameterController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(StationsParameterController.class);
    private ParameterService<StationOutput> parameterService;
    @Autowired
    private ProceduresParameterController parameterControllerWithHref;
    @Autowired
    @Qualifier(value="metadataService")
    private CountingMetadataService counter;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getCollection(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) {
        Integer elementcount;
        OutputCollection result;
        Stopwatch stopwatch;
        IoParameters map = this.createParameters(query, locale).respectBackwardsCompatibility();
        if (map.isExpanded()) {
            stopwatch = Stopwatch.startStopwatch();
            result = this.parameterService.getExpandedParameters(map);
            this.logRequestTime(stopwatch);
        } else {
            stopwatch = Stopwatch.startStopwatch();
            result = this.parameterService.getCondensedParameters(map);
            this.logRequestTime(stopwatch);
        }
        if ((map.containsParameter("limit") || map.containsParameter("offset")) && (elementcount = Integer.valueOf(this.counter.getStationCount())) != -1) {
            OffsetBasedPagination obp = new OffsetBasedPagination((long)map.getOffset(), (long)map.getLimit());
            Paginated paginated = new Paginated((Pagination)obp, elementcount.longValue());
            this.addPagingHeaders(response, paginated);
        }
        return new ModelAndView().addObject((Object)result.getItems());
    }

    protected MultiValueMap<String, String> addHrefBase(MultiValueMap<String, String> query) {
        query.put((Object)"internal.href.base", Collections.singletonList(this.getHrefBase()));
        return query;
    }

    private String getHrefBase() {
        return RequestUtils.resolveQueryLessRequestUrl(this.parameterControllerWithHref.getExternalUrl());
    }

    @RequestMapping(value={"/{item}"}, method={RequestMethod.GET})
    public ModelAndView getItem(@PathVariable(value="item") String procedureId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) {
        IoParameters parameters = this.createParameters(query, locale);
        Stopwatch stopwatch = Stopwatch.startStopwatch();
        ParameterOutput result = this.parameterService.getParameter(procedureId, parameters);
        this.logRequestTime(stopwatch);
        if (result == null) {
            throw new ResourceNotFoundException("Found no station with given id.");
        }
        return new ModelAndView().addObject((Object)result);
    }

    public ParameterService<StationOutput> getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService<StationOutput> stationParameterService) {
        TransformingStationOutputService service = new TransformingStationOutputService(stationParameterService);
        this.parameterService = new LocaleAwareSortService(new SpiAssertionExceptionAdapter(service));
    }

    private void logRequestTime(Stopwatch stopwatch) {
        LOGGER.debug("Processing request took {} seconds.", (Object)stopwatch.stopInSeconds());
    }

    private HttpServletResponse addPagingHeaders(HttpServletResponse response, Paginated paginated) {
        String l = "Link:";
        String href = new UrlHelper().constructHref(this.getHrefBase(), "/stations");
        if (paginated.getCurrent().isPresent()) {
            response.addHeader(l, "<" + href + "?" + paginated.getCurrent().get().toString() + "> rel=\"self\"");
        }
        if (paginated.getNext().isPresent()) {
            response.addHeader(l, "<" + href + "?" + paginated.getNext().get().toString() + "> rel=\"next\"");
        }
        if (paginated.getPrevious().isPresent()) {
            response.addHeader(l, "<" + href + "?" + paginated.getPrevious().get().toString() + "> rel=\"previous\"");
        }
        if (paginated.getFirst().isPresent()) {
            response.addHeader(l, "<" + href + "?" + paginated.getFirst().get().toString() + "> rel=\"first\"");
        }
        if (paginated.getLast().isPresent()) {
            response.addHeader(l, "<" + href + "?" + paginated.getLast().get().toString() + "> rel=\"last\"");
        }
        return response;
    }
}

