/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.n52.io.DatasetFactoryException;
import org.n52.io.DefaultIoFactory;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.IoFactory;
import org.n52.io.IoHandlerException;
import org.n52.io.PreRenderingJob;
import org.n52.io.format.quantity.FormatterFactory;
import org.n52.io.generalize.quantity.GeneralizingQuantityService;
import org.n52.io.request.IoParameters;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.request.RequestStyledParameterSet;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DataCollection;
import org.n52.io.response.dataset.ValueType;
import org.n52.io.response.dataset.quantity.QuantityDatasetOutput;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.series.spi.srv.DataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.series.spi.srv.RawDataService;
import org.n52.web.common.Stopwatch;
import org.n52.web.ctrl.BaseController;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.n52.web.exception.SpiAssertionExceptionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Deprecated
@RestController
@RequestMapping(value={"/timeseries"}, produces={"application/json"})
public class TimeseriesDataController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeseriesDataController.class);
    private ParameterService<QuantityDatasetOutput> timeseriesMetadataService;
    private DataService<Data<QuantityValue>> timeseriesDataService;
    private PreRenderingJob preRenderingTask;
    private boolean handlingPreRenderingTask;
    private String requestIntervalRestriction;

    @Override
    protected IoParameters createParameters(RequestSimpleParameterSet query, String locale) {
        return super.createParameters(query, locale).respectBackwardsCompatibility();
    }

    @Override
    protected IoParameters createParameters(RequestStyledParameterSet query, String locale) {
        return super.createParameters(query, locale).respectBackwardsCompatibility();
    }

    @Override
    protected IoParameters createParameters(MultiValueMap<String, String> query, String locale) {
        return super.createParameters(query, locale).respectBackwardsCompatibility();
    }

    @Override
    protected IoParameters createParameters(String datasetId, MultiValueMap<String, String> query, String locale) {
        return super.createParameters(datasetId, query, locale).respectBackwardsCompatibility();
    }

    @Override
    protected IoParameters createParameters(Map<String, String> query, String locale) {
        return super.createParameters(query, locale).respectBackwardsCompatibility();
    }

    @Override
    protected IoParameters createParameters(String datasetId, Map<String, String> query, String locale) {
        return super.createParameters(datasetId, query, locale).respectBackwardsCompatibility();
    }

    @RequestMapping(value={"/getData"}, produces={"application/json"}, method={RequestMethod.POST})
    public ModelAndView getCollectionData(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestSimpleParameterSet request) throws Exception {
        IoParameters parameters = this.createParameters(request, locale);
        this.checkIfUnknownTimeseriesIds(parameters, parameters.getDatasets());
        if (parameters.isSetRawFormat()) {
            this.getRawCollectionData(response, locale, request);
            return null;
        }
        DataCollection<Data<QuantityValue>> seriesData = this.getTimeseriesData(parameters);
        DataCollection<?> formattedDataCollection = this.format(seriesData, parameters);
        return new ModelAndView().addObject((Object)formattedDataCollection.getAllSeries());
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView getData(HttpServletResponse response, @PathVariable String timeseriesId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> request) {
        IoParameters parameters = this.createParameters(timeseriesId, request, locale);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkIfUnknownTimeseriesId(parameters, timeseriesId);
        DataCollection<Data<QuantityValue>> seriesData = this.getTimeseriesData(parameters);
        DataCollection<?> formattedDataCollection = this.format(seriesData, parameters);
        if (parameters.isExpanded()) {
            return new ModelAndView().addObject((Object)formattedDataCollection.getAllSeries());
        }
        Object formattedTimeseries = formattedDataCollection.getAllSeries().get(timeseriesId);
        return new ModelAndView().addObject(formattedTimeseries);
    }

    private DataCollection<Data<QuantityValue>> getTimeseriesData(IoParameters parameters) {
        Stopwatch stopwatch = Stopwatch.startStopwatch();
        DataCollection timeseriesData = parameters.isGeneralize() ? new GeneralizingQuantityService(this.timeseriesDataService).getData(parameters) : this.timeseriesDataService.getData(parameters);
        LOGGER.debug("Processing request took {} seconds.", (Object)stopwatch.stopInSeconds());
        return timeseriesData;
    }

    @RequestMapping(value={"/getData"}, method={RequestMethod.POST}, params={"rawFormat"})
    public void getRawCollectionData(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestSimpleParameterSet request) throws Exception {
        IoParameters parameters = this.createParameters(request, locale);
        this.checkIfUnknownTimeseriesIds(parameters, parameters.getDatasets());
        this.processRawDataRequest(response, parameters);
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, method={RequestMethod.GET}, params={"rawFormat"})
    public void getRawData(HttpServletResponse response, @PathVariable String timeseriesId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam MultiValueMap<String, String> request) {
        IoParameters parameters = this.createParameters(timeseriesId, request, locale);
        this.checkIfUnknownTimeseriesId(parameters, timeseriesId);
        this.processRawDataRequest(response, parameters);
    }

    private void processRawDataRequest(HttpServletResponse response, IoParameters parameters) {
        if (!this.timeseriesDataService.supportsRawData()) {
            this.throwNewRawDataQueryNotSupportedException();
        }
        RawDataService rawDataService = this.timeseriesDataService.getRawDataService();
        try (InputStream inputStream = rawDataService.getRawData(parameters);){
            if (inputStream == null) {
                throw new ResourceNotFoundException("No raw data found.");
            }
            response.setContentType(parameters.getFormat());
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new InternalServerException("Error while querying raw data", e);
        }
    }

    private DataCollection<?> format(DataCollection<Data<QuantityValue>> timeseriesData, IoParameters parameters) {
        return FormatterFactory.createFormatterFactory((IoParameters)parameters).create().format(timeseriesData);
    }

    @RequestMapping(value={"/getData"}, produces={"application/pdf"}, method={RequestMethod.POST})
    public void getCollectionReport(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestStyledParameterSet request) throws Exception {
        IoParameters parameters = this.createParameters(request, locale);
        this.checkIfUnknownTimeseriesIds(parameters, parameters.getDatasets());
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        response.setContentType("application/pdf");
        this.createIoFactory(parameters).createHandler("application/pdf").writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, produces={"application/pdf"}, method={RequestMethod.GET})
    public void getReport(HttpServletResponse response, @PathVariable String timeseriesId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> request) throws Exception {
        IoParameters parameters = this.createParameters(timeseriesId, request, locale);
        this.checkIfUnknownTimeseriesId(parameters, timeseriesId);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        response.setContentType("application/pdf");
        this.createIoFactory(parameters).createHandler("application/pdf").writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, produces={"application/zip"}, method={RequestMethod.GET})
    public void getAsZippedCsv(HttpServletResponse response, @PathVariable String timeseriesId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters parameters = this.createParameters(timeseriesId, query, locale);
        parameters = parameters.extendWith("zip", new String[]{Boolean.TRUE.toString()});
        response.setContentType("application/zip");
        this.getTimeseriesAsCsv(timeseriesId, parameters, response);
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, produces={"text/csv"}, method={RequestMethod.GET})
    public void getAsCsv(HttpServletResponse response, @PathVariable String timeseriesId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> request) throws Exception {
        IoParameters parameters = this.createParameters(timeseriesId, request, locale);
        this.getTimeseriesAsCsv(timeseriesId, parameters, response);
    }

    private void getTimeseriesAsCsv(String timeseriesId, IoParameters parameters, HttpServletResponse response) throws IoHandlerException, DatasetFactoryException, URISyntaxException, MalformedURLException, IOException {
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkIfUnknownTimeseriesId(parameters, timeseriesId);
        response.setCharacterEncoding("UTF-8");
        if (Boolean.parseBoolean(parameters.getOther("zip"))) {
            response.setContentType("application/zip");
        } else {
            response.setContentType("text/csv");
        }
        this.createIoFactory(parameters).createHandler("text/csv").writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/getData"}, produces={"image/png"}, method={RequestMethod.POST})
    public void getCollectionChart(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestStyledParameterSet request) throws Exception {
        IoParameters parameters = this.createParameters(request, locale);
        this.checkIfUnknownTimeseriesIds(parameters, parameters.getDatasets());
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        response.setContentType("image/png");
        this.createIoFactory(parameters).createHandler("image/png").writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{timeseriesId}/getData"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getChart(HttpServletResponse response, @PathVariable String timeseriesId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters parameters = this.createParameters(timeseriesId, query, locale);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkIfUnknownTimeseriesId(parameters, timeseriesId);
        response.setContentType("image/png");
        this.createIoFactory(parameters).createHandler("image/png").writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{timeseriesId}/{chartQualifier}"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getChartByInterval(HttpServletResponse response, @PathVariable String timeseriesId, @PathVariable String chartQualifier, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> request) throws Exception {
        if (this.preRenderingTask == null || this.isHandlingPreRenderingTask()) {
            throw new ResourceNotFoundException("Diagram prerendering is not enabled.");
        }
        String datasetId = ValueType.createId((String)"quantity", (String)timeseriesId);
        if (!this.preRenderingTask.hasPrerenderedImage(datasetId, chartQualifier)) {
            throw new ResourceNotFoundException("No pre-rendered chart found for timeseries '" + timeseriesId + "'.");
        }
        this.preRenderingTask.writePrerenderedGraphToOutputStream(datasetId, chartQualifier, (OutputStream)response.getOutputStream());
    }

    private void checkAgainstTimespanRestriction(IntervalWithTimeZone timespan) {
        Duration duration = Period.parse((String)this.requestIntervalRestriction).toDurationFrom((ReadableInstant)new DateTime());
        if (duration.getMillis() < Interval.parse((String)timespan.toString()).toDurationMillis()) {
            throw new BadRequestException("Requested timespan is to long, please use a period shorter than '" + this.requestIntervalRestriction + "'");
        }
    }

    private void checkIfUnknownTimeseriesId(IoParameters parameters, String timeseriesId) {
        this.checkIfUnknownTimeseriesIds(parameters, Collections.singleton(timeseriesId));
    }

    private void checkIfUnknownTimeseriesIds(IoParameters parameters, Set<String> timeseriesIds) {
        for (String timeseriesId : timeseriesIds) {
            if (this.timeseriesMetadataService.exists(timeseriesId, parameters)) continue;
            throw new ResourceNotFoundException("The timeseries with id '" + timeseriesId + "' was not found.");
        }
    }

    private IoFactory<QuantityDatasetOutput, QuantityValue> createIoFactory(IoParameters parameters) throws DatasetFactoryException, URISyntaxException, MalformedURLException {
        return ((IoFactory)this.createDefaultIoFactory().create("quantity")).setParameters(parameters).setBasePath(this.getRootResource()).setDataService(this.timeseriesDataService).setDatasetService(this.timeseriesMetadataService);
    }

    private DefaultIoFactory<QuantityDatasetOutput, QuantityValue> createDefaultIoFactory() {
        return new DefaultIoFactory();
    }

    private URI getRootResource() throws URISyntaxException, MalformedURLException {
        return this.getServletConfig().getServletContext().getResource("/").toURI();
    }

    public ParameterService<QuantityDatasetOutput> getTimeseriesMetadataService() {
        return this.timeseriesMetadataService;
    }

    public void setTimeseriesMetadataService(ParameterService<QuantityDatasetOutput> timeseriesMetadataService) {
        this.timeseriesMetadataService = new SpiAssertionExceptionAdapter<QuantityDatasetOutput>(timeseriesMetadataService);
    }

    public DataService<Data<QuantityValue>> getTimeseriesDataService() {
        return this.timeseriesDataService;
    }

    public void setTimeseriesDataService(DataService<Data<QuantityValue>> timeseriesDataService) {
        this.timeseriesDataService = timeseriesDataService;
    }

    public PreRenderingJob getPreRenderingTask() {
        return this.preRenderingTask;
    }

    public boolean isHandlingPreRenderingTask() {
        return this.handlingPreRenderingTask;
    }

    public void setHandlingPreRenderingTask(boolean handlingPreRenderingTask) {
        this.handlingPreRenderingTask = handlingPreRenderingTask;
    }

    public void setPreRenderingTask(PreRenderingJob prerenderingTask) {
        this.preRenderingTask = prerenderingTask;
    }

    public String getRequestIntervalRestriction() {
        return this.requestIntervalRestriction;
    }

    public void setRequestIntervalRestriction(String requestIntervalRestriction) {
        Period.parse((String)requestIntervalRestriction);
        this.requestIntervalRestriction = requestIntervalRestriction;
    }

    private void throwNewRawDataQueryNotSupportedException() {
        throw new BadRequestException("Querying of raw procedure data is not supported by the underlying service!");
    }
}

