/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.n52.io.HrefHelper;

public class HrefHelperTest {
    @Test
    public void when_constructBackwardsCompatibleUrl_then_relativeLink() {
        String actual = HrefHelper.constructHref(null, (String)"/procedures");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)"./procedures"));
    }

    @Test
    public void when_constructUrlWithNonTrailingSlashBaseUrl_then_fullLink() {
        String actual = HrefHelper.constructHref((String)"http://localhost:8080/foo/bar", (String)"/procedures");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)"http://localhost:8080/foo/bar/procedures"));
    }

    @Test
    public void when_constructUrlFromBaseUrl_then_fullLink() {
        String actual = HrefHelper.constructHref((String)"http://localhost:8080/foo/bar/", (String)"/procedures");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)"http://localhost:8080/foo/bar/procedures"));
    }

    @Test
    public void given_baseUrlWithoutTrailingSlash_when_pathWithTrailingSlash_then_fullLink() {
        String actual = HrefHelper.constructHref((String)"http://localhost:8080/foo/bar", (String)"procedures");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)"http://localhost:8080/foo/bar/procedures"));
    }
}

