/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.common;

import java.util.Optional;
import java.util.StringJoiner;
import org.n52.web.common.Pagination;

public class Paginated {
    private final Optional<Pagination> current;
    private final Optional<Pagination> last;
    private final Optional<Pagination> first;
    private final Optional<Pagination> prev;
    private final Optional<Pagination> next;
    private final long elements;

    public Paginated(Pagination current, long elements) {
        this.current = Optional.ofNullable(current);
        this.elements = elements;
        if (this.current.isPresent()) {
            this.last = this.current.get().last(this.elements);
            this.first = this.current.get().first(this.elements);
            this.prev = this.current.get().previous(this.elements);
            this.next = this.current.get().next(this.elements);
        } else {
            Optional absent = Optional.empty();
            this.last = absent;
            this.first = absent;
            this.prev = absent;
            this.next = absent;
        }
    }

    public Optional<Pagination> getLast() {
        return this.last;
    }

    public boolean hasLast() {
        return this.last.isPresent();
    }

    public Optional<Pagination> getNext() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next.isPresent();
    }

    public Optional<Pagination> getCurrent() {
        return this.current;
    }

    public Optional<Pagination> getPrevious() {
        return this.prev;
    }

    public boolean hasPrevious() {
        return this.prev.isPresent();
    }

    public Optional<Pagination> getFirst() {
        return this.first;
    }

    public boolean hasFirst() {
        return this.first.isPresent();
    }

    public boolean isPaginated() {
        return this.current.isPresent();
    }

    public long getTotalCount() {
        return this.elements;
    }

    public String toString() {
        return new StringJoiner(", ", Paginated.class.getSimpleName() + "[", "]").add("first=" + this.getFirst().orElse(null)).add("previous=" + this.getPrevious().orElse(null)).add("current=" + this.getCurrent().orElse(null)).add("next=" + this.getNext().orElse(null)).add("last=" + this.getLast().orElse(null)).toString();
    }
}

