/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.n52.io.DatasetFactoryException;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.PreRenderingJob;
import org.n52.io.handler.DefaultIoFactory;
import org.n52.io.handler.IoHandlerFactory;
import org.n52.io.handler.IoProcessChain;
import org.n52.io.request.IoParameters;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.request.RequestStyledParameterSet;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DataCollection;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.ValueType;
import org.n52.series.spi.srv.DataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.series.spi.srv.RawDataService;
import org.n52.web.ctrl.BaseController;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/datasets"}, produces={"application/json"})
public class DataController
extends BaseController {
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final String CONTENT_DISPOSITION_VALUE_TEMPLATE = "attachment; filename=\"Data_for_Dataset_";
    private static final String SHOWTIMEINTERVALS_QUERY_OPTION = "showTimeIntervals";
    private static final Logger LOGGER = LoggerFactory.getLogger(DataController.class);
    private static final String DEFAULT_RESPONSE_ENCODING = "UTF-8";
    private final DefaultIoFactory<DatasetOutput<AbstractValue<?>>, AbstractValue<?>> ioFactoryCreator;
    private final DataService<Data<AbstractValue<?>>> dataService;
    private final ParameterService<DatasetOutput<AbstractValue<?>>> datasetService;
    private PreRenderingJob preRenderingTask;
    @Value(value="${requestIntervalRestriction:P370D}")
    private String requestIntervalRestriction;

    public DataController(DefaultIoFactory<DatasetOutput<AbstractValue<?>>, AbstractValue<?>> ioFactory, ParameterService<DatasetOutput<AbstractValue<?>>> datasetService, DataService<Data<AbstractValue<?>>> dataService) {
        this.ioFactoryCreator = ioFactory;
        this.datasetService = datasetService;
        this.dataService = dataService;
    }

    @RequestMapping(value={"/{datasetId}/data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView getSeriesData(HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters map = this.createParameters(datasetId, query, locale);
        LOGGER.debug("get data for item '{}' with query: {}", (Object)datasetId, (Object)map);
        this.checkAgainstTimespanRestriction(map.getTimespan());
        this.checkForUnknownDatasetId(map.removeAllOf("bbox").removeAllOf("near"), datasetId);
        String handleAsValueTypeFallback = map.getAsString("handleAs");
        String valueType = ValueType.extractType((String)datasetId, (String)handleAsValueTypeFallback);
        IoProcessChain ioChain = this.createIoFactory(valueType).setParameters(map).createProcessChain();
        DataCollection formattedDataCollection = ioChain.getProcessedData();
        Map processed = formattedDataCollection.getAllSeries();
        return map.isExpanded() ? new ModelAndView().addObject((Object)processed) : new ModelAndView().addObject(processed.get(datasetId));
    }

    @RequestMapping(value={"/data"}, produces={"application/json"}, method={RequestMethod.POST})
    public ModelAndView getCollectionData(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestSimpleParameterSet simpleParameters) throws Exception {
        IoParameters parameters = this.createParameters(simpleParameters, locale);
        LOGGER.debug("get data collection with parameter set: {}", (Object)parameters);
        this.checkForUnknownDatasetIds(parameters, parameters.getDatasets());
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        String datasetType = this.getValueType(parameters);
        IoProcessChain ioChain = this.createIoFactory(datasetType).setParameters(parameters).createProcessChain();
        DataCollection processed = ioChain.getData();
        return new ModelAndView().addObject((Object)processed.getAllSeries());
    }

    private String getValueType(IoParameters parameters) {
        String handleAs = parameters.getOther("handleAs");
        Set datasetIds = parameters.getDatasets();
        Iterator iterator = datasetIds.iterator();
        return iterator.hasNext() ? ValueType.extractType((String)((String)iterator.next()), (String)handleAs) : "quantity";
    }

    @RequestMapping(value={"/data"}, params={"rawFormat"}, method={RequestMethod.POST})
    public void getRawSeriesCollectionData(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestSimpleParameterSet simpleParameters) throws Exception {
        IoParameters parameters = this.createParameters(simpleParameters, locale);
        this.checkForUnknownDatasetIds(parameters, parameters.getDatasets());
        this.writeRawData(parameters, response);
    }

    @RequestMapping(value={"/{datasetId}/data"}, method={RequestMethod.GET}, params={"rawFormat"})
    public void getRawSeriesData(HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam MultiValueMap<String, String> query) {
        IoParameters parameters = this.createParameters(datasetId, query, locale);
        this.checkForUnknownDatasetId(parameters, datasetId);
        this.writeRawData(parameters, response);
    }

    private void writeRawData(IoParameters parameters, HttpServletResponse response) throws InternalServerException, ResourceNotFoundException, BadRequestException {
        LOGGER.debug("get raw data collection with parameters: {}", (Object)parameters);
        if (!this.dataService.supportsRawData()) {
            throw new BadRequestException("Querying of raw timeseries data is not supported by the underlying service!");
        }
        RawDataService rawDataService = this.dataService.getRawDataService();
        try (InputStream inputStream = rawDataService.getRawData(parameters);){
            if (inputStream == null) {
                throw new ResourceNotFoundException("No raw data found.");
            }
            response.setContentType(parameters.getRawFormat());
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new InternalServerException("Error while querying raw data", e);
        }
    }

    @RequestMapping(value={"/data"}, produces={"application/pdf"}, method={RequestMethod.POST})
    public void getSeriesCollectionReport(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestStyledParameterSet request) throws Exception {
        IoParameters parameters = this.createParameters(request, locale);
        LOGGER.debug("get data collection report with query: {}", (Object)parameters);
        this.checkForUnknownDatasetIds(parameters, parameters.getDatasets());
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        String datasetType = this.getValueType(parameters);
        String outputFormat = "application/pdf";
        response.setContentType(outputFormat);
        this.createIoFactory(datasetType).setParameters(parameters).createHandler(outputFormat).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/data"}, produces={"application/pdf"}, method={RequestMethod.GET})
    public void getSeriesReport(HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters parameters = this.createParameters(datasetId, query, locale);
        LOGGER.debug("get data collection report for '{}' with query: {}", (Object)datasetId, (Object)parameters);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkForUnknownDatasetId(parameters, datasetId);
        String datasetType = this.getValueType(parameters);
        String outputFormat = "application/pdf";
        response.setContentType(outputFormat);
        response.setHeader(CONTENT_DISPOSITION_HEADER, CONTENT_DISPOSITION_VALUE_TEMPLATE + datasetId + ".pdf\"");
        this.createIoFactory(datasetType).setParameters(parameters).createHandler(outputFormat).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/data"}, produces={"application/zip"}, method={RequestMethod.GET})
    public void getSeriesAsZippedCsv(HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        query.putIfAbsent((Object)SHOWTIMEINTERVALS_QUERY_OPTION, Arrays.asList(Boolean.TRUE.toString()));
        IoParameters parameters = this.createParameters(datasetId, query, locale);
        LOGGER.debug("get data collection zip for '{}' with query: {}", (Object)datasetId, (Object)parameters);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkForUnknownDatasetId(parameters, datasetId);
        response.setCharacterEncoding(DEFAULT_RESPONSE_ENCODING);
        response.setContentType("application/zip");
        response.setHeader(CONTENT_DISPOSITION_HEADER, CONTENT_DISPOSITION_VALUE_TEMPLATE + datasetId + ".zip\"");
        String datasetType = this.getValueType(parameters);
        this.createIoFactory(datasetType).setParameters(parameters).createHandler("application/zip").writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/data"}, produces={"text/csv"}, method={RequestMethod.GET})
    public void getSeriesAsCsv(HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        query.putIfAbsent((Object)SHOWTIMEINTERVALS_QUERY_OPTION, Arrays.asList(Boolean.TRUE.toString()));
        IoParameters parameters = this.createParameters(datasetId, query, locale);
        LOGGER.debug("get data collection csv for '{}' with query: {}", (Object)datasetId, (Object)parameters);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkForUnknownDatasetId(parameters, datasetId);
        String extension = ".";
        response.setCharacterEncoding(DEFAULT_RESPONSE_ENCODING);
        if (Boolean.parseBoolean(parameters.getOther("zip"))) {
            response.setContentType("application/zip");
            extension = extension + "zip";
        } else {
            response.setContentType("text/csv");
            extension = extension + "csv";
        }
        response.setHeader(CONTENT_DISPOSITION_HEADER, CONTENT_DISPOSITION_VALUE_TEMPLATE + datasetId + extension + "\"");
        String datasetType = this.getValueType(parameters);
        this.createIoFactory(datasetType).setParameters(parameters).createHandler("text/csv").writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/data"}, produces={"image/png"}, method={RequestMethod.POST})
    public void getSeriesCollectionChart(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestStyledParameterSet request) throws Exception {
        IoParameters parameters = this.createParameters(request, locale);
        LOGGER.debug("get data collection chart with query: {}", (Object)parameters);
        this.checkForUnknownDatasetIds(parameters, parameters.getDatasets());
        String datasetType = this.getValueType(parameters);
        String outputFormat = "image/png";
        response.setContentType(outputFormat);
        this.createIoFactory(datasetType).setParameters(parameters).createHandler(outputFormat).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/data"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getSeriesChart(HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters parameters = this.createParameters(datasetId, query, locale);
        LOGGER.debug("get data collection chart for '{}' with query: {}", (Object)datasetId, (Object)parameters);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkForUnknownDatasetId(parameters, datasetId);
        String handleAsValueTypeFallback = parameters.getAsString("handleAs");
        String valueType = ValueType.extractType((String)datasetId, (String)handleAsValueTypeFallback);
        String outputFormat = "image/png";
        response.setContentType(outputFormat);
        this.createIoFactory(valueType).setParameters(parameters).createHandler(outputFormat).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/images"}, method={RequestMethod.GET})
    public ModelAndView getSeriesChartByInterval(@PathVariable String datasetId) {
        this.assertPrerenderingIsEnabled();
        ModelAndView response = new ModelAndView();
        return response.addObject(this.preRenderingTask.getPrerenderedImages(datasetId));
    }

    @RequestMapping(value={"/{datasetId}/{chartQualifier}"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getSeriesChartByInterval(HttpServletResponse response, @PathVariable String datasetId, @PathVariable String chartQualifier) throws Exception {
        this.assertPrerenderingIsEnabled();
        this.assertPrerenderedImageIsAvailable(datasetId, chartQualifier);
        response.setContentType("image/png");
        LOGGER.debug("get prerendered chart for '{}' ({})", (Object)datasetId, (Object)chartQualifier);
        this.preRenderingTask.writePrerenderedGraphToOutputStream(datasetId, chartQualifier, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/images/{fileName}"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getSeriesChartByFilename(HttpServletResponse response, @PathVariable String datasetId, @PathVariable String fileName) throws Exception {
        this.assertPrerenderingIsEnabled();
        this.assertPrerenderedImageIsAvailable(fileName, null);
        response.setContentType("image/png");
        LOGGER.debug("get prerendered chart for '{}'", (Object)fileName);
        this.preRenderingTask.writePrerenderedGraphToOutputStream(fileName, (OutputStream)response.getOutputStream());
    }

    private void checkAgainstTimespanRestriction(IntervalWithTimeZone timespan) {
        Duration duration;
        if (this.requestIntervalRestriction != null && (duration = Period.parse((String)this.requestIntervalRestriction).toDurationFrom((ReadableInstant)new DateTime())).getMillis() < Interval.parse((String)timespan.toString()).toDurationMillis()) {
            throw new BadRequestException("Timespan too long, please use a period shorter than '" + this.requestIntervalRestriction + "'");
        }
    }

    private void checkForUnknownDatasetId(IoParameters parameters, String seriesId) {
        this.checkForUnknownDatasetIds(parameters, Collections.singleton(seriesId));
    }

    private void checkForUnknownDatasetIds(IoParameters parameters, Set<String> seriesIds) {
        if (seriesIds != null) {
            for (String id : seriesIds) {
                if (this.datasetService.exists(id, parameters)) continue;
                throw new ResourceNotFoundException("Series with id '" + id + "' wasn't found.");
            }
        }
    }

    private IoHandlerFactory<DatasetOutput<AbstractValue<?>>, AbstractValue<?>> createIoFactory(String valueType) throws DatasetFactoryException {
        if (!this.ioFactoryCreator.isKnown(valueType)) {
            throw new ResourceNotFoundException("unknown dataset type: " + valueType);
        }
        return ((IoHandlerFactory)this.ioFactoryCreator.create(valueType)).setDataService(this.dataService).setDatasetService(this.datasetService);
    }

    public PreRenderingJob getPreRenderingTask() {
        return this.preRenderingTask;
    }

    public void setPreRenderingTask(PreRenderingJob prerenderingTask) {
        this.preRenderingTask = prerenderingTask;
    }

    public String getRequestIntervalRestriction() {
        return this.requestIntervalRestriction;
    }

    public void setRequestIntervalRestriction(String requestIntervalRestriction) {
        Period.parse((String)requestIntervalRestriction);
        LOGGER.debug("CONFIG: request.interval.restriction={}", (Object)requestIntervalRestriction);
        this.requestIntervalRestriction = requestIntervalRestriction;
    }

    private void assertPrerenderingIsEnabled() {
        if (this.preRenderingTask == null) {
            throw new ResourceNotFoundException("Diagram prerendering is not enabled.");
        }
    }

    private void assertPrerenderedImageIsAvailable(String seriesId, String chartQualifier) {
        if (!this.preRenderingTask.hasPrerenderedImage(seriesId, chartQualifier)) {
            throw new ResourceNotFoundException("No pre-rendered chart found for datasetId '" + seriesId + " (qualifier: " + chartQualifier + ")'.");
        }
    }
}

