/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.n52.io.request.IoParameters;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.extension.MetadataExtension;
import org.n52.series.spi.srv.LocaleAwareSortService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.common.OffsetBasedPagination;
import org.n52.web.common.PageLinkUtil;
import org.n52.web.common.Paginated;
import org.n52.web.common.Stopwatch;
import org.n52.web.ctrl.BaseController;
import org.n52.web.ctrl.RawDataController;
import org.n52.web.ctrl.ResourceController;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.n52.web.exception.SpiAssertionExceptionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.ModelAndView;

public abstract class ParameterController<T extends ParameterOutput>
extends BaseController
implements ResourceController,
RawDataController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterController.class);
    private List<MetadataExtension<T>> metadataExtensions = new ArrayList<MetadataExtension<T>>();
    private final ParameterService<T> parameterService;

    @Autowired
    public ParameterController(ParameterService<T> parameterService) {
        SpiAssertionExceptionAdapter<T> service = new SpiAssertionExceptionAdapter<T>(parameterService);
        this.parameterService = new LocaleAwareSortService(service);
    }

    @Override
    public void getRawData(HttpServletResponse response, String id, String locale, MultiValueMap<String, String> query) {
        if (!this.parameterService.supportsRawData()) {
            throw new BadRequestException("Querying raw procedure data is not supported!");
        }
        IoParameters queryMap = this.createParameters(query, locale);
        LOGGER.debug("getRawData() with id '{}' and query '{}'", (Object)id, (Object)queryMap);
        try (InputStream inputStream = this.parameterService.getRawDataService().getRawData(id, queryMap);){
            if (inputStream == null) {
                throw new ResourceNotFoundException("No raw data found for id '" + id + "'.");
            }
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new InternalServerException("Error while querying raw data", e);
        }
    }

    @Override
    public Map<String, Object> getExtras(String resourceId, String locale, MultiValueMap<String, String> query) {
        IoParameters map = this.createParameters(query, locale);
        LOGGER.debug("getExtras() with id '{}' and query '{}'", (Object)resourceId, (Object)map);
        HashMap<String, Object> extras = new HashMap<String, Object>();
        for (MetadataExtension<T> extension : this.metadataExtensions) {
            ParameterOutput from;
            Map furtherExtras = extension.getExtras(from = this.parameterService.getParameter(resourceId, map), map);
            Collection<String> overridableKeys = this.checkForOverridingData(extras, furtherExtras);
            if (!overridableKeys.isEmpty()) {
                Object[] keys = overridableKeys.toArray(new String[0]);
                LOGGER.warn("Metadata extension overrides existing extra data: {}", (Object)Arrays.toString(keys));
            }
            extras.putAll(furtherExtras);
        }
        return extras;
    }

    private Collection<String> checkForOverridingData(Map<String, Object> data, Map<String, Object> dataToAdd) {
        HashMap<String, Object> currentData = new HashMap<String, Object>(data);
        Set<String> overridableKeys = currentData.keySet();
        overridableKeys.retainAll(dataToAdd.keySet());
        return overridableKeys;
    }

    protected ModelAndView createModelAndView(OutputCollection<T> items, IoParameters parameters) {
        return new ModelAndView().addObject((Object)items.getItems());
    }

    protected ModelAndView createModelAndView(T item, IoParameters parameters) {
        return new ModelAndView().addObject(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelAndView getCollection(HttpServletResponse response, String locale, MultiValueMap<String, String> query) {
        Stopwatch stopwatch = Stopwatch.startStopwatch();
        IoParameters parameters = this.createParameters(query, locale);
        try {
            LOGGER.debug("getCollection() with query '{}'", (Object)parameters);
            this.preparePagingHeaders(parameters, response);
            ModelAndView modelAndView = this.createModelAndView((T)this.getCollection(parameters), parameters);
            return modelAndView;
        }
        finally {
            LOGGER.debug("Processing request took {} seconds.", (Object)stopwatch.stopInSeconds());
        }
    }

    private OutputCollection<T> getCollection(IoParameters parameters) {
        return parameters.isExpanded() ? this.addExtensionInfos(this.parameterService.getExpandedParameters(parameters), parameters) : this.parameterService.getCondensedParameters(parameters);
    }

    private void preparePagingHeaders(IoParameters parameters, HttpServletResponse response) {
        Integer elementcount;
        if ((parameters.containsParameter("limit") || parameters.containsParameter("offset")) && (elementcount = Integer.valueOf(this.getElementCount(parameters.removeAllOf("limit").removeAllOf("offset")))) > 0) {
            int limit = parameters.getLimit();
            int offset = parameters.getOffset();
            OffsetBasedPagination obp = new OffsetBasedPagination(offset, limit);
            Paginated paginated = new Paginated(obp, elementcount.longValue());
            PageLinkUtil.addPagingHeaders(this.createCollectionUrl(this.getCollectionName()), response, paginated);
        }
    }

    @Override
    public ModelAndView getItem(String id, String locale, MultiValueMap<String, String> query) {
        IoParameters parameters = this.createParameters(query, locale);
        LOGGER.debug("getItem() with id '{}' and query '{}'", (Object)id, (Object)parameters);
        return this.createModelAndView(this.getItem(id, parameters), parameters);
    }

    private T getItem(String id, IoParameters parameters) {
        ParameterOutput item = this.parameterService.getParameter(id, parameters);
        if (item == null) {
            throw new ResourceNotFoundException("Resource with id '" + id + "' not found.");
        }
        return (T)this.addExtensionInfos(item, parameters);
    }

    protected T addExtensionInfos(T output, IoParameters parameters) {
        Collection extras = this.metadataExtensions.stream().map(e -> e.getExtraMetadataFieldNames(output)).flatMap(c -> c.stream()).collect(Collectors.toList());
        output.setValue("extras", (Object)extras, parameters, arg_0 -> output.setExtras(arg_0));
        return output;
    }

    private OutputCollection<T> addExtensionInfos(OutputCollection<T> toBeProcessed, IoParameters ioParameters) {
        for (ParameterOutput parameterOutput : toBeProcessed) {
            this.addExtensionInfos(parameterOutput, ioParameters);
        }
        return toBeProcessed;
    }

    public void addMetadataExtension(MetadataExtension<T> extension) {
        if (this.metadataExtensions != null) {
            this.metadataExtensions.add(extension);
        }
    }

    public List<MetadataExtension<T>> getMetadataExtensions() {
        return this.metadataExtensions;
    }

    public void setMetadataExtensions(List<MetadataExtension<T>> metadataExtensions) {
        this.metadataExtensions = metadataExtensions;
    }

    protected abstract int getElementCount(IoParameters var1);
}

