/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.n52.io.response.ParameterOutput;
import org.n52.series.spi.srv.CountingMetadataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.ctrl.ParameterController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(method={RequestMethod.GET})
public abstract class ParameterRequestMappingAdapter<T extends ParameterOutput>
extends ParameterController<T> {
    private final CountingMetadataService counter;

    @Autowired
    public ParameterRequestMappingAdapter(CountingMetadataService counter, ParameterService<T> parameterService) {
        super(parameterService);
        this.counter = counter;
    }

    @Override
    @RequestMapping(path={""}, produces={"application/json"})
    public ModelAndView getCollection(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam MultiValueMap<String, String> query) {
        return super.getCollection(response, locale, this.addHrefBase(query));
    }

    @Override
    @RequestMapping(value={"/{item}"}, produces={"application/json"})
    public ModelAndView getItem(@PathVariable(value="item") String id, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam MultiValueMap<String, String> query) {
        return super.getItem(id, locale, this.addHrefBase(query));
    }

    @Override
    @RequestMapping(value={"/{item}"}, produces={"application/json"}, params={"rawFormat"})
    public void getRawData(HttpServletResponse response, @PathVariable(value="item") String id, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam MultiValueMap<String, String> query) {
        super.getRawData(response, id, locale, this.addHrefBase(query));
    }

    @Override
    @RequestMapping(value={"/{item}/extras"}, produces={"application/json"})
    public Map<String, Object> getExtras(@PathVariable(value="item") String resourceId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) {
        return super.getExtras(resourceId, locale, this.addHrefBase(query));
    }

    protected MultiValueMap<String, String> addHrefBase(MultiValueMap<String, String> query) {
        List<String> value = Collections.singletonList(this.getExternalUrl());
        query.put((Object)"internal.href.base", value);
        return query;
    }

    protected CountingMetadataService getEntityCounter() {
        return this.counter;
    }
}

