/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.n52.io.I18N;
import org.n52.io.request.IoParameters;
import org.n52.series.spi.srv.CountingMetadataService;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/"}, produces={"application/json"})
public class ResourcesController {
    private CountingMetadataService metadataService;

    @RequestMapping(value={"/"})
    public ModelAndView getResources(HttpServletResponse response, @RequestParam(required=false) MultiValueMap<String, String> parameters) {
        this.addVersionHeader(response);
        IoParameters query = IoParameters.createFromMultiValueMap(parameters).respectBackwardsCompatibility();
        return new ModelAndView().addObject(this.createResources(query));
    }

    private ResourceCollection add(String resource, String label, String description) {
        return ResourceCollection.createResource(resource).withDescription(description).withLabel(label);
    }

    private List<ResourceCollection> createResources(IoParameters parameters) {
        I18N i18n = I18N.getMessageLocalizer((String)parameters.getLocale());
        ResourceCollection services = this.add("services", "Service Provider", i18n.get("msg.web.resources.services"));
        ResourceCollection stations = this.add("stations", "Station", i18n.get("msg.web.resources.stations"));
        ResourceCollection timeseries = this.add("timeseries", "Timeseries", i18n.get("msg.web.resources.timeseries"));
        ResourceCollection categories = this.add("categories", "Category", i18n.get("msg.web.resources.categories"));
        ResourceCollection offerings = this.add("offerings", "Offering", i18n.get("msg.web.resources.offerings"));
        ResourceCollection features = this.add("features", "Feature", i18n.get("msg.web.resources.features"));
        ResourceCollection procedures = this.add("procedures", "Procedure", i18n.get("msg.web.resources.procedures"));
        ResourceCollection phenomena = this.add("phenomena", "Phenomenon", i18n.get("msg.web.resources.phenomena"));
        if (parameters.isExpanded()) {
            services.setSize(this.getMetadataService().getServiceCount(parameters));
            if (parameters.shallBehaveBackwardsCompatible()) {
                stations.setSize(this.getMetadataService().getStationCount());
                timeseries.setSize(this.getMetadataService().getTimeseriesCount());
            }
            categories.setSize(this.getMetadataService().getCategoryCount(parameters));
            offerings.setSize(this.getMetadataService().getOfferingCount(parameters));
            features.setSize(this.getMetadataService().getFeatureCount(parameters));
            procedures.setSize(this.getMetadataService().getProcedureCount(parameters));
            phenomena.setSize(this.getMetadataService().getPhenomenaCount(parameters));
        }
        ArrayList<ResourceCollection> resources = new ArrayList<ResourceCollection>();
        resources.add(services);
        resources.add(stations);
        resources.add(timeseries);
        resources.add(categories);
        resources.add(offerings);
        resources.add(features);
        resources.add(procedures);
        resources.add(phenomena);
        ResourceCollection platforms = this.add("platforms", "Platforms", i18n.get("msg.web.resources.platforms"));
        ResourceCollection datasets = this.add("datasets", "Datasets", i18n.get("msg.web.resources.datasets"));
        ResourceCollection geometries = this.add("geometries", "Geometries", i18n.get("msg.web.resources.geometries"));
        resources.add(platforms);
        resources.add(datasets);
        resources.add(geometries);
        if (parameters.isExpanded()) {
            platforms.setSize(this.getMetadataService().getPlatformCount(parameters));
            datasets.setSize(this.getMetadataService().getDatasetCount(parameters));
        }
        return resources;
    }

    private void addVersionHeader(HttpServletResponse response) {
        String implementationVersion = this.getClass().getPackage().getImplementationVersion();
        String version = implementationVersion != null ? implementationVersion : "unknown";
        response.addHeader("API-Version", version);
    }

    public CountingMetadataService getMetadataService() {
        return this.metadataService;
    }

    public void setMetadataService(CountingMetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public static final class ResourceCollection {
        private String id;
        private String label;
        private String description;
        private Integer size;

        private ResourceCollection(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public ResourceCollection withLabel(String name) {
            this.label = name;
            return this;
        }

        public ResourceCollection withDescription(String details) {
            this.description = details;
            return this;
        }

        public ResourceCollection withCount(Integer count) {
            this.size = count;
            return this;
        }

        public static ResourceCollection createResource(String id) {
            return new ResourceCollection(id);
        }
    }
}

