/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.common;

import java.util.Objects;
import java.util.Optional;
import org.n52.web.common.Pagination;

public class OffsetBasedPagination
implements Pagination {
    private final long limit;
    private final long offset;
    private final long start;
    private final long end;

    public OffsetBasedPagination() {
        this(0L, 0L);
    }

    public OffsetBasedPagination(long offset, long limit) {
        this.limit = limit <= 0L ? 10000L : Math.min(limit, 1000000L);
        this.start = this.offset = offset <= 0L ? 0L : offset * limit;
        this.end = this.offset + this.limit;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public Optional<Pagination> first(long elements) {
        if (this.offset >= elements) {
            return Optional.empty();
        }
        return Optional.of(new OffsetBasedPagination(0L, this.limit));
    }

    @Override
    public Optional<Pagination> previous(long elements) {
        if (this.offset >= elements || this.offset == 0L || this.offset >= elements) {
            return Optional.empty();
        }
        return Optional.of(new OffsetBasedPagination(this.offset / this.limit - 1L, this.limit));
    }

    @Override
    public Optional<Pagination> next(long elements) {
        if (this.offset >= elements || this.offset + this.limit >= elements) {
            return Optional.empty();
        }
        return Optional.of(new OffsetBasedPagination(this.offset / this.limit + 1L, this.limit));
    }

    @Override
    public Optional<Pagination> last(long elements) {
        long maxOffset = elements - (elements % this.limit == 0L ? this.limit : elements % this.limit);
        if (this.offset >= elements) {
            return Optional.empty();
        }
        return Optional.of(new OffsetBasedPagination(maxOffset / this.limit, this.limit));
    }

    public int hashCode() {
        return Objects.hash(this.offset / this.limit, this.limit);
    }

    public boolean equals(Object obj) {
        if (obj instanceof OffsetBasedPagination) {
            OffsetBasedPagination that = (OffsetBasedPagination)obj;
            return this.getOffset() == that.getOffset() && this.getLimit() == that.getLimit();
        }
        return false;
    }

    public String toString() {
        return "offset=" + this.offset / this.limit + "&limit=" + this.limit;
    }
}

