/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.n52.io.extension.RenderingHintsExtension;
import org.n52.io.extension.StatusIntervalsExtension;
import org.n52.io.request.IoParameters;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.request.RequestStyledParameterSet;
import org.n52.io.request.StyleProperties;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.dataset.TimeseriesMetadataOutput;
import org.n52.io.response.extension.MetadataExtension;
import org.n52.series.spi.srv.CountingMetadataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.ctrl.ParameterRequestMappingAdapter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/timeseries"})
public class TimeseriesMetadataController
extends ParameterRequestMappingAdapter<TimeseriesMetadataOutput> {
    public TimeseriesMetadataController(CountingMetadataService counter, ParameterService<TimeseriesMetadataOutput> service) {
        super(counter, service);
    }

    @Override
    protected ModelAndView createModelAndView(OutputCollection<TimeseriesMetadataOutput> items, IoParameters parameters) {
        items.stream().forEach(e -> {
            this.addRenderingHints((TimeseriesMetadataOutput)e, parameters);
            this.addStatusIntervals((TimeseriesMetadataOutput)e, parameters);
        });
        return super.createModelAndView(items, parameters);
    }

    @Override
    protected ModelAndView createModelAndView(TimeseriesMetadataOutput item, IoParameters parameters) {
        this.addRenderingHints(item, parameters);
        this.addStatusIntervals(item, parameters);
        return super.createModelAndView(item, parameters);
    }

    private TimeseriesMetadataOutput addRenderingHints(TimeseriesMetadataOutput output, IoParameters parameters) {
        if (parameters.isRenderingHintsRequests()) {
            String valueName = "renderingHints";
            Predicate<MetadataExtension<?>> filter = RenderingHintsExtension.class::isInstance;
            Optional<Map<String, Object>> extras = this.getExtras(output, parameters, filter);
            extras.ifPresent(it -> {
                StyleProperties value = (StyleProperties)it.get("renderingHints");
                output.setValue("renderingHints", (Object)value, parameters, arg_0 -> ((TimeseriesMetadataOutput)output).setRenderingHints(arg_0));
            });
        }
        return output;
    }

    private TimeseriesMetadataOutput addStatusIntervals(TimeseriesMetadataOutput output, IoParameters parameters) {
        if (parameters.isStatusIntervalsRequests()) {
            String valueName = "statusIntervals";
            Predicate<MetadataExtension<?>> filter = StatusIntervalsExtension.class::isInstance;
            Optional<Map<String, Object>> extras = this.getExtras(output, parameters, filter);
            extras.ifPresent(it -> {
                Collection value = (Collection)it.get("statusIntervals");
                output.setValue("statusIntervals", (Object)value, parameters, arg_0 -> ((TimeseriesMetadataOutput)output).setStatusIntervals(arg_0));
            });
        }
        return output;
    }

    @Override
    protected IoParameters createParameters(RequestSimpleParameterSet query, String locale) {
        return super.createParameters(query, locale).respectBackwardsCompatibility();
    }

    @Override
    protected IoParameters createParameters(RequestStyledParameterSet query, String locale) {
        return super.createParameters(query, locale).respectBackwardsCompatibility();
    }

    @Override
    protected IoParameters createParameters(MultiValueMap<String, String> query, String locale) {
        return super.createParameters(query, locale).respectBackwardsCompatibility();
    }

    @Override
    protected IoParameters createParameters(String datasetId, MultiValueMap<String, String> query, String locale) {
        return super.createParameters(datasetId, query, locale).respectBackwardsCompatibility();
    }

    @Override
    protected IoParameters createParameters(Map<String, String> query, String locale) {
        return super.createParameters(query, locale).respectBackwardsCompatibility();
    }

    @Override
    protected IoParameters createParameters(String datasetId, Map<String, String> query, String locale) {
        return super.createParameters(datasetId, query, locale).respectBackwardsCompatibility();
    }

    @Override
    public String getCollectionName() {
        return "/timeseries";
    }

    @Override
    protected int getElementCount(IoParameters queryMap) {
        return super.getEntityCounter().getTimeseriesCount();
    }

    private Optional<Map<String, Object>> getExtras(TimeseriesMetadataOutput output, IoParameters parameters, Predicate<MetadataExtension<?>> isExtension) {
        return this.getMetadataExtensions().stream().map(x -> x).filter(isExtension).map(x -> x).map(x -> x.getExtras((ParameterOutput)output, parameters)).findFirst();
    }
}

