/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.exception;

import org.n52.io.Utils;
import org.n52.web.exception.WebException;
import org.springframework.http.HttpStatus;

public final class ExceptionResponse {
    private Throwable exception;
    private HttpStatus statusCode;
    private String[] hints;

    private ExceptionResponse(Throwable e, HttpStatus statusCode, String[] hints) {
        this.hints = hints != null ? (String[])hints.clone() : null;
        this.statusCode = statusCode;
        this.exception = e;
    }

    private ExceptionResponse(Throwable e, HttpStatus statusCode) {
        this(e, statusCode, null);
    }

    public int getStatusCode() {
        return this.statusCode.value();
    }

    public String getReason() {
        return this.statusCode.getReasonPhrase();
    }

    public String getUserMessage() {
        return this.exception.getMessage();
    }

    public String getDeveloperMessage() {
        Throwable causedBy = this.exception.getCause();
        return causedBy != null ? this.formatMessageOutput(causedBy) : null;
    }

    private String formatMessageOutput(Throwable causedBy) {
        String message = causedBy.getMessage();
        return message != null ? message.replace("\"", "'") : null;
    }

    public String[] getHints() {
        return (String[])Utils.copy((Object[])this.hints);
    }

    public static ExceptionResponse createExceptionResponse(WebException e, HttpStatus statusCode) {
        return new ExceptionResponse(e.getThrowable(), statusCode, e.getHints());
    }
}

