/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl.data;

import org.n52.io.handler.DefaultIoFactory;
import org.n52.io.request.IoParameters;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.series.spi.srv.DataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.ctrl.data.DataController;
import org.n52.web.exception.ResourceNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/timeseries"}, produces={"application/json"})
public class TimeseriesDataController
extends DataController {
    @Autowired
    public TimeseriesDataController(DefaultIoFactory<DatasetOutput<AbstractValue<?>>, AbstractValue<?>> ioFactory, ParameterService<DatasetOutput<AbstractValue<?>>> datasetService, DataService<Data<AbstractValue<?>>> dataService) {
        super(ioFactory, datasetService, dataService);
    }

    @Override
    protected String checkAndGetDataType(IoParameters map, String requestUrl) {
        OutputCollection condensedParameters = this.getDatasetService().getCondensedParameters(map);
        DatasetOutput item = (DatasetOutput)condensedParameters.getItem(0);
        if (!item.getDatasetType().equalsIgnoreCase("timeseries")) {
            throw new ResourceNotFoundException("The dataset with id '" + item.getId() + "' was not found for '" + "/timeseries" + "'.");
        }
        return item.getObservationType().equals("profile") || item.getDatasetType().equals("profile") ? "profile" : item.getValueType();
    }
}

