/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.common;

import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.n52.web.common.Paginated;
import org.n52.web.common.Pagination;

public final class PageLinkUtil {
    private PageLinkUtil() {
    }

    public static void addPagingHeaders(String href, HttpServletResponse response, Paginated paginated) {
        PageLinkUtil.addLinkHeader("self", href, paginated.getCurrent(), response);
        PageLinkUtil.addLinkHeader("previous", href, paginated.getPrevious(), response);
        PageLinkUtil.addLinkHeader("next", href, paginated.getNext(), response);
        PageLinkUtil.addLinkHeader("first", href, paginated.getFirst(), response);
        PageLinkUtil.addLinkHeader("last", href, paginated.getLast(), response);
    }

    private static void addLinkHeader(String rel, String href, Optional<Pagination> pagination, HttpServletResponse response) {
        if (pagination.isPresent()) {
            String header = "Link";
            Pagination pageLink = pagination.get();
            StringBuilder sb = new StringBuilder();
            String value = sb.append("<").append(href).append("?").append(pageLink.toString()).append("> rel=\"").append(rel).append("\"").toString();
            response.addHeader(header, value);
        }
    }
}

