/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.n52.io.I18N;
import org.n52.io.request.IoParameters;
import org.n52.series.spi.srv.CountingMetadataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/"}, produces={"application/json"})
public class ResourcesController {
    private static final String TIMESERIES = "timeseries";
    private static final String TAJECTORIES = "trajectories";
    private static final String INDIVIDUAL_OBSERVATIONS = "individualObservations";
    private final CountingMetadataService metadataService;

    @Autowired
    public ResourcesController(CountingMetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @RequestMapping(value={"/"})
    public ModelAndView getResources(HttpServletResponse response, @RequestParam(required=false) MultiValueMap<String, String> parameters) {
        this.addVersionHeader(response);
        IoParameters query = IoParameters.createFromMultiValueMap(parameters);
        return new ModelAndView().addObject(this.createResources(query));
    }

    private ResourceCollection add(String resource, String label, String description) {
        return ResourceCollection.createResource(resource).withDescription(description).withLabel(label);
    }

    private List<ResourceCollection> createResources(IoParameters parameters) {
        I18N i18n = I18N.getMessageLocalizer((String)parameters.getLocale());
        ResourceCollection services = this.add("services", "Service Provider", i18n.get("msg.web.resources.services"));
        ResourceCollection timeseries = this.add(TIMESERIES, "Timeseries", i18n.get("msg.web.resources.timeseries"));
        ResourceCollection categories = this.add("categories", "Category", i18n.get("msg.web.resources.categories"));
        ResourceCollection offerings = this.add("offerings", "Offering", i18n.get("msg.web.resources.offerings"));
        ResourceCollection features = this.add("features", "Feature", i18n.get("msg.web.resources.features"));
        ResourceCollection procedures = this.add("procedures", "Procedure", i18n.get("msg.web.resources.procedures"));
        ResourceCollection phenomena = this.add("phenomena", "Phenomenon", i18n.get("msg.web.resources.phenomena"));
        if (parameters.isExpanded()) {
            services.setSize(this.metadataService.getServiceCount(parameters));
            categories.setSize(this.metadataService.getCategoryCount(parameters));
            offerings.setSize(this.metadataService.getOfferingCount(parameters));
            features.setSize(this.metadataService.getFeatureCount(parameters));
            procedures.setSize(this.metadataService.getProcedureCount(parameters));
            phenomena.setSize(this.metadataService.getPhenomenaCount(parameters));
        }
        ArrayList<ResourceCollection> resources = new ArrayList<ResourceCollection>();
        resources.add(services);
        resources.add(timeseries);
        resources.add(categories);
        resources.add(offerings);
        resources.add(features);
        resources.add(procedures);
        resources.add(phenomena);
        ResourceCollection platforms = this.add("platforms", "Platforms", i18n.get("msg.web.resources.platforms"));
        ResourceCollection datasets = this.add("datasets", "Datasets", i18n.get("msg.web.resources.datasets"));
        ResourceCollection individualObservations = this.add(INDIVIDUAL_OBSERVATIONS, "IndividualObservations", i18n.get("msg.web.resources.individualObservations"));
        ResourceCollection trajectories = this.add(TAJECTORIES, "Trajectories", i18n.get("msg.web.resources.trajectories"));
        resources.add(platforms);
        resources.add(datasets);
        resources.add(individualObservations);
        resources.add(trajectories);
        if (parameters.isExpanded()) {
            platforms.setSize(this.metadataService.getPlatformCount(parameters));
            datasets.setSize(this.metadataService.getDatasetCount(parameters));
            LinkedList datasetTypes = new LinkedList(parameters.getDatasetTypes());
            timeseries.setSize(this.countDatasets(parameters, TIMESERIES));
            trajectories.setSize(this.countDatasets(parameters, TAJECTORIES));
            individualObservations.setSize(this.countDatasets(parameters, INDIVIDUAL_OBSERVATIONS));
            parameters.extendWith("datasetTypes", datasetTypes);
        }
        ResourceCollection samplings = this.add("samplings", "Samplings", i18n.get("msg.web.resources.samplings"));
        ResourceCollection measuringPrograms = this.add("measuringPrograms", "MeasuringPrograms", i18n.get("msg.web.resources.measuringPrograms"));
        resources.add(samplings);
        resources.add(measuringPrograms);
        return resources;
    }

    private int countDatasets(IoParameters parameters, String datasetType) {
        String filterName = "datasetTypes";
        IoParameters filter = parameters.extendWith(filterName, new String[]{datasetType});
        return this.metadataService.getDatasetCount(filter);
    }

    private void addVersionHeader(HttpServletResponse response) {
        String implementationVersion = this.getClass().getPackage().getImplementationVersion();
        String version = implementationVersion != null ? implementationVersion : "unknown";
        response.addHeader("API-Version", version);
    }

    public static final class ResourceCollection {
        private String id;
        private String label;
        private String description;
        private Integer size;

        private ResourceCollection(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public ResourceCollection withLabel(String name) {
            this.label = name;
            return this;
        }

        public ResourceCollection withDescription(String details) {
            this.description = details;
            return this;
        }

        public ResourceCollection withCount(Integer count) {
            this.size = count;
            return this;
        }

        public static ResourceCollection createResource(String id) {
            return new ResourceCollection(id);
        }
    }
}

