/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.n52.io.request.IoParameters;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.dataset.StationOutput;
import org.n52.series.spi.geo.TransformingStationOutputService;
import org.n52.series.spi.srv.CountingMetadataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.common.OffsetBasedPagination;
import org.n52.web.common.PageLinkUtil;
import org.n52.web.common.Paginated;
import org.n52.web.common.Stopwatch;
import org.n52.web.ctrl.BaseController;
import org.n52.web.ctrl.ResourceController;
import org.n52.web.exception.ResourceNotFoundException;
import org.n52.web.exception.SpiAssertionExceptionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Deprecated
@RestController
@RequestMapping(value={"/stations"}, produces={"application/json"})
public class StationsParameterController
extends BaseController
implements ResourceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(StationsParameterController.class);
    private final ParameterService<StationOutput> parameterService;
    private final CountingMetadataService counter;

    @Autowired
    public StationsParameterController(CountingMetadataService counter, ParameterService<StationOutput> service) {
        TransformingStationOutputService transformingService = new TransformingStationOutputService(service);
        this.parameterService = new SpiAssertionExceptionAdapter<StationOutput>((ParameterService<StationOutput>)transformingService);
        this.counter = counter;
    }

    @Override
    public String getCollectionName() {
        return "/stations";
    }

    @Override
    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getCollection(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) {
        Integer elementcount;
        OutputCollection result;
        Stopwatch stopwatch;
        IoParameters map = this.createParameters(query, locale, response).respectBackwardsCompatibility();
        if (map.isExpanded()) {
            stopwatch = Stopwatch.startStopwatch();
            result = this.parameterService.getExpandedParameters(map);
            this.logRequestTime(stopwatch);
        } else {
            stopwatch = Stopwatch.startStopwatch();
            result = this.parameterService.getCondensedParameters(map);
            this.logRequestTime(stopwatch);
        }
        if ((map.containsParameter("limit") || map.containsParameter("offset")) && (elementcount = Integer.valueOf(this.counter.getStationCount())) != -1) {
            OffsetBasedPagination obp = new OffsetBasedPagination(map.getOffset(), map.getLimit());
            Paginated paginated = new Paginated(obp, elementcount.longValue());
            String collectionHref = this.createCollectionUrl(this.getCollectionName());
            PageLinkUtil.addPagingHeaders(collectionHref, response, paginated);
        }
        return new ModelAndView().addObject((Object)result.getItems());
    }

    protected MultiValueMap<String, String> addHrefBase(MultiValueMap<String, String> query) {
        List<String> value = Collections.singletonList(this.getExternalUrl());
        query.put((Object)"internal.href.base", value);
        return query;
    }

    @Override
    @RequestMapping(value={"/{item}"}, method={RequestMethod.GET})
    public ModelAndView getItem(@PathVariable(value="item") String procedureId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query, HttpServletResponse response) {
        IoParameters parameters = this.createParameters(query, locale, response);
        Stopwatch stopwatch = Stopwatch.startStopwatch();
        ParameterOutput result = this.parameterService.getParameter(procedureId, parameters);
        this.logRequestTime(stopwatch);
        if (result == null) {
            throw new ResourceNotFoundException("Found no station with given id.");
        }
        return new ModelAndView().addObject((Object)result);
    }

    private void logRequestTime(Stopwatch stopwatch) {
        LOGGER.debug("Processing request took {} seconds.", (Object)stopwatch.stopInSeconds());
    }

    @Override
    protected void addCacheHeader(IoParameters parameter, HttpServletResponse response) {
        if (parameter.hasCache() && ((JsonNode)parameter.getCache().get()).has(this.getResourcePathFrom("/stations"))) {
            this.addCacheHeader(response, ((JsonNode)parameter.getCache().get()).get(this.getResourcePathFrom("/stations")).asLong(0L));
        }
    }
}

