/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.extension;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.n52.io.extension.RenderingHintsExtensionConfig;
import org.n52.io.request.IoParameters;
import org.n52.io.request.StyleProperties;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.extension.MetadataExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderingHintsExtension<T extends DatasetOutput<?>>
extends MetadataExtension<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderingHintsExtension.class);
    private static final String CONFIG_FILE = "/config-rendering-hints.json";
    private static final String EXTENSION_NAME = "renderingHints";
    private final RenderingHintsExtensionConfig renderingConfig = this.readConfig();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RenderingHintsExtensionConfig readConfig() {
        try (InputStream config = ((Object)((Object)this)).getClass().getResourceAsStream(CONFIG_FILE);){
            ObjectMapper om = new ObjectMapper();
            RenderingHintsExtensionConfig renderingHintsExtensionConfig = (RenderingHintsExtensionConfig)om.readValue(config, RenderingHintsExtensionConfig.class);
            return renderingHintsExtensionConfig;
        }
        catch (IOException e) {
            LOGGER.error("Could not load {}. Using empty config.", (Object)CONFIG_FILE, (Object)e);
            return new RenderingHintsExtensionConfig();
        }
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Collection<String> getExtraMetadataFieldNames(T output) {
        return this.hasRenderingHints(output) ? Collections.singleton(EXTENSION_NAME) : Collections.emptySet();
    }

    private boolean hasRenderingHints(T output) {
        return this.hasSeriesConfiguration(output) || this.hasPhenomenonConfiguration(output);
    }

    private boolean hasSeriesConfiguration(T output) {
        return this.renderingConfig.getTimeseriesStyles().containsKey(output.getId());
    }

    private boolean hasPhenomenonConfiguration(T output) {
        String id = output.getDatasetParameters(true).getPhenomenon().getId();
        return this.renderingConfig.getPhenomenonStyles().containsKey(id);
    }

    public Map<String, Object> getExtras(T output, IoParameters parameters) {
        if (!this.hasExtrasToReturn(output, parameters)) {
            return Collections.emptyMap();
        }
        if (this.hasSeriesConfiguration(output)) {
            return this.wrapSingleIntoMap(this.createStyle(this.getSeriesStyle(output)));
        }
        if (this.hasPhenomenonConfiguration(output)) {
            return this.wrapSingleIntoMap(this.createStyle(this.getPhenomenonStyle(output)));
        }
        LOGGER.error("No rendering style found for {} (id={})", output, (Object)output.getId());
        return Collections.emptyMap();
    }

    protected boolean hasExtrasToReturn(T output, IoParameters parameters) {
        return super.hasExtrasToReturn(output, parameters) && this.hasRenderingHints(output);
    }

    private RenderingHintsExtensionConfig.ConfiguredStyle getSeriesStyle(T output) {
        return this.renderingConfig.getTimeseriesStyles().get(output.getId());
    }

    private RenderingHintsExtensionConfig.ConfiguredStyle getPhenomenonStyle(T output) {
        String id = output.getDatasetParameters().getPhenomenon().getId();
        return this.renderingConfig.getPhenomenonStyles().get(id);
    }

    private StyleProperties createStyle(RenderingHintsExtensionConfig.ConfiguredStyle configuredStyle) {
        return configuredStyle.getStyle();
    }
}

