/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl.data;

import java.text.MessageFormat;
import org.n52.io.handler.DefaultIoFactory;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.series.spi.srv.DataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.ctrl.data.DataController;
import org.n52.web.exception.ResourceNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/individualObservations"}, produces={"application/json"})
public class IndividualObservationsDataController
extends DataController {
    @Autowired
    public IndividualObservationsDataController(DefaultIoFactory<DatasetOutput<AbstractValue<?>>, AbstractValue<?>> ioFactory, ParameterService<DatasetOutput<AbstractValue<?>>> datasetService, DataService<Data<AbstractValue<?>>> dataService) {
        super(ioFactory, datasetService, dataService);
    }

    @Override
    protected String getValueType(IoParameters map, String requestUrl) {
        DatasetOutput<AbstractValue<?>> item = this.getFirstDatasetOutput(map);
        String datasetType = item.getDatasetType();
        if (!"individualObservation".equalsIgnoreCase(datasetType)) {
            String expectedType = "/individualObservations";
            String template = "The dataset with id ''{0}'' was not found for ''{1}''.";
            String message = MessageFormat.format(template, item.getId(), expectedType);
            throw new ResourceNotFoundException(message);
        }
        return this.isProfileType(item) ? "profile" : item.getValueType();
    }
}

