/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl.data;

import java.io.OutputStream;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.io.PreRenderingJob;
import org.n52.io.handler.DefaultIoFactory;
import org.n52.io.request.IoParameters;
import org.n52.io.request.RequestStyledParameterSet;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.series.spi.srv.DataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.web.ctrl.data.DataController;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/timeseries"}, produces={"application/json"})
public class TimeseriesDataController
extends DataController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeseriesDataController.class);
    private PreRenderingJob preRenderingTask;

    @Autowired
    public TimeseriesDataController(DefaultIoFactory<DatasetOutput<AbstractValue<?>>, AbstractValue<?>> ioFactory, ParameterService<DatasetOutput<AbstractValue<?>>> datasetService, DataService<Data<AbstractValue<?>>> dataService) {
        super(ioFactory, datasetService, dataService);
    }

    @RequestMapping(value={"/observations"}, produces={"image/png"}, method={RequestMethod.POST})
    public void getSeriesCollectionChart(HttpServletRequest request, HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestStyledParameterSet simpleParameters) throws Exception {
        IoParameters parameters = this.createParameters(simpleParameters, locale, response);
        LOGGER.debug("get data collection chart with query: {}", (Object)parameters);
        this.checkForUnknownDatasetIds(parameters, parameters.getDatasets());
        String valueType = this.getValueType(parameters, request.getRequestURI());
        String outputFormat = "image/png";
        response.setContentType(outputFormat);
        this.createIoFactory(valueType).setParameters(parameters).createHandler(outputFormat).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/observations"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getSeriesChart(HttpServletRequest request, HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters parameters = this.createParameters(datasetId, query, locale, response);
        LOGGER.debug("get data collection chart for '{}' with query: {}", (Object)datasetId, (Object)parameters);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkForUnknownDatasetId(parameters, datasetId);
        String valueType = this.getValueType(parameters, request.getRequestURI());
        String outputFormat = "image/png";
        response.setContentType(outputFormat);
        this.createIoFactory(valueType).setParameters(parameters).createHandler(outputFormat).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/images"}, method={RequestMethod.GET})
    public ModelAndView getSeriesChartByInterval(@PathVariable String datasetId) {
        this.assertPrerenderingIsEnabled();
        ModelAndView response = new ModelAndView();
        return response.addObject(this.preRenderingTask.getPrerenderedImages(datasetId));
    }

    @RequestMapping(value={"/{datasetId}/{chartQualifier}"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getSeriesChartByInterval(HttpServletResponse response, @PathVariable String datasetId, @PathVariable String chartQualifier) throws Exception {
        this.assertPrerenderingIsEnabled();
        this.assertPrerenderedImageIsAvailable(datasetId, chartQualifier);
        response.setContentType("image/png");
        LOGGER.debug("get prerendered chart for '{}' ({})", (Object)datasetId, (Object)chartQualifier);
        this.preRenderingTask.writePrerenderedGraphToOutputStream(datasetId, chartQualifier, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/images/{fileName}"}, produces={"image/png"}, method={RequestMethod.GET})
    public void getSeriesChartByFilename(HttpServletResponse response, @PathVariable String datasetId, @PathVariable String fileName) throws Exception {
        this.assertPrerenderingIsEnabled();
        this.assertPrerenderedImageIsAvailable(fileName, null);
        response.setContentType("image/png");
        LOGGER.debug("get prerendered chart for '{}'", (Object)fileName);
        this.preRenderingTask.writePrerenderedGraphToOutputStream(fileName, (OutputStream)response.getOutputStream());
    }

    @Deprecated
    @RequestMapping(value={"/{datasetId}/getData"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView getTimeseriesData(HttpServletRequest request, HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        query.add((Object)"unixTime", (Object)"true");
        return this.getSeriesData(request, response, datasetId, locale, query);
    }

    @Override
    protected String getValueType(IoParameters map, String requestUrl) {
        DatasetOutput<AbstractValue<?>> item = this.getFirstDatasetOutput(map);
        String datasetType = item.getDatasetType();
        if (!"timeseries".equalsIgnoreCase(datasetType)) {
            String expectedType = "/timeseries";
            String template = "The dataset with id ''{0}'' was not found for ''{1}''.";
            String message = MessageFormat.format(template, item.getId(), expectedType);
            throw new ResourceNotFoundException(message);
        }
        return this.isProfileType(item) ? "profile" : item.getValueType();
    }

    public PreRenderingJob getPreRenderingTask() {
        return this.preRenderingTask;
    }

    public void setPreRenderingTask(PreRenderingJob prerenderingTask) {
        this.preRenderingTask = prerenderingTask;
    }

    private void assertPrerenderingIsEnabled() {
        if (this.preRenderingTask == null) {
            throw new ResourceNotFoundException("Diagram prerendering is not enabled.");
        }
    }

    private void assertPrerenderedImageIsAvailable(String seriesId, String chartQualifier) {
        if (!this.preRenderingTask.hasPrerenderedImage(seriesId, chartQualifier)) {
            throw new ResourceNotFoundException("No pre-rendered chart found for datasetId '" + seriesId + " (qualifier: " + chartQualifier + ")'.");
        }
    }
}

