/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.io.Constants;
import org.n52.io.HrefHelper;
import org.n52.io.IoParseException;
import org.n52.io.request.IoParameters;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.request.RequestStyledParameterSet;
import org.n52.web.common.RequestUtils;
import org.n52.web.ctrl.ResourcesController;
import org.n52.web.exception.BadQueryParameterException;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.ExceptionResponse;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.n52.web.exception.WebException;
import org.n52.web.exception.WebExceptionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;

@RestController
public abstract class BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourcesController.class);
    private static final String REFER_TO_API_SYNTAX = "Refer to the API documentation and check parameter value against required syntax!";
    private static final String INVALID_REQUEST_BODY = "Check the request body which has been sent to the server. Probably it is not valid.";
    private static final String HEADER_ACCEPT = "Accept";
    @Value(value="${external.url:http://localhost:8080/api}")
    private String externalUrl;

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = RequestUtils.resolveQueryLessRequestUrl(externalUrl);
    }

    public String createCollectionUrl(String collectionName) {
        return HrefHelper.constructHref((String)this.getExternalUrl(), (String)collectionName);
    }

    protected BiConsumer<String, IoParseException> getExceptionHandle() {
        return (parameter, e) -> {
            BadRequestException ex = new BadRequestException("Invalid '" + parameter + "' parameter.", (Throwable)e);
            throw ex.addHint(REFER_TO_API_SYNTAX).addHint(e.getMessage()).addHint(e.getHints());
        };
    }

    protected IoParameters createParameters(RequestSimpleParameterSet query, String locale, HttpServletResponse response) {
        return this.createParameters(query.toParameters(), locale, response);
    }

    protected IoParameters createParameters(RequestStyledParameterSet query, String locale, HttpServletResponse response) {
        return this.createParameters(query.toParameters(), locale, response);
    }

    protected IoParameters createParameters(MultiValueMap<String, String> query, String locale, HttpServletResponse response) {
        return this.createParameters(IoParameters.createFromMultiValueMap(query), locale, response);
    }

    protected IoParameters createParameters(String datasetId, MultiValueMap<String, String> query, String locale, HttpServletResponse response) {
        IoParameters parameters = IoParameters.createFromMultiValueMap(query).replaceWith("datasets", new String[]{datasetId});
        return this.createParameters(parameters, locale, response);
    }

    protected IoParameters createParameters(Map<String, String> query, String locale, HttpServletResponse response) {
        return this.createParameters(IoParameters.createFromSingleValueMap(query), locale, response);
    }

    protected IoParameters createParameters(String datasetId, Map<String, String> query, String locale, HttpServletResponse response) {
        IoParameters parameters = IoParameters.createFromSingleValueMap(query).replaceWith("datasets", new String[]{datasetId});
        return this.createParameters(parameters, locale, response);
    }

    private IoParameters createParameters(IoParameters parameters, String locale, HttpServletResponse response) {
        if (parameters != null && response != null) {
            this.addCacheHeader(parameters, response);
        }
        return RequestUtils.overrideQueryLocaleWhenSet(locale, parameters).setParseExceptionHandle(this.getExceptionHandle());
    }

    protected boolean isRequestingJsonData(HttpServletRequest request) {
        return Constants.MimeType.APPLICATION_JSON.getMimeType().equals(BaseController.getAcceptHeader(request));
    }

    protected boolean isRequestingPdfData(HttpServletRequest request) {
        return Constants.MimeType.APPLICATION_PDF.getMimeType().equals(BaseController.getAcceptHeader(request));
    }

    protected boolean isRequestingPngData(HttpServletRequest request) {
        return Constants.MimeType.IMAGE_PNG.getMimeType().equals(BaseController.getAcceptHeader(request));
    }

    private static String getAcceptHeader(HttpServletRequest request) {
        return request.getHeader(HEADER_ACCEPT);
    }

    @ExceptionHandler(value={BadRequestException.class, BadQueryParameterException.class})
    public void handle400(Exception e, HttpServletRequest request, HttpServletResponse response) {
        this.writeExceptionResponse((WebException)((Object)e), response, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public void handle404(Exception e, HttpServletRequest request, HttpServletResponse response) {
        this.writeExceptionResponse((WebException)((Object)e), response, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InternalServerException.class})
    public void handle500(Exception e, HttpServletRequest request, HttpServletResponse response) {
        this.writeExceptionResponse((WebException)((Object)e), response, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={RuntimeException.class, Exception.class, Throwable.class})
    public void handleException(Exception e, HttpServletRequest request, HttpServletResponse response) {
        if (e instanceof HttpMessageNotReadableException) {
            WebExceptionAdapter ex = new BadRequestException("Invalid Request", e).addHint(INVALID_REQUEST_BODY).addHint(REFER_TO_API_SYNTAX);
            this.writeExceptionResponse(ex, response, HttpStatus.BAD_REQUEST);
        } else {
            InternalServerException wrappedException = new InternalServerException("Unexpected Exception occured.", e);
            this.writeExceptionResponse(wrappedException, response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void writeExceptionResponse(WebException e, HttpServletResponse response, HttpStatus status) {
        String logMessage = "An exception occured.";
        if (status == HttpStatus.INTERNAL_SERVER_ERROR) {
            LOGGER.error("An exception occured.", (Object)e);
        } else {
            LOGGER.debug("An exception occured.", (Object)e);
        }
        response.setStatus(status.value());
        response.setContentType(Constants.MimeType.APPLICATION_JSON.getMimeType());
        ObjectMapper objectMapper = this.createObjectMapper();
        ObjectWriter writer = objectMapper.writerFor(ExceptionResponse.class);
        ExceptionResponse exceptionResponse = ExceptionResponse.createExceptionResponse(e, status);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            writer.writeValue((OutputStream)outputStream, (Object)exceptionResponse);
        }
        catch (IOException ioe) {
            LOGGER.error("Could not process error message.", (Throwable)ioe);
        }
    }

    protected ObjectMapper createObjectMapper() {
        return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    protected abstract void addCacheHeader(IoParameters var1, HttpServletResponse var2);

    protected void addCacheHeader(HttpServletResponse response, long maxAge) {
        String maxAgeHeader = maxAge > 0L ? CacheControl.maxAge((long)maxAge, (TimeUnit)TimeUnit.MINUTES).getHeaderValue() : CacheControl.noStore().getHeaderValue();
        response.setHeader("Cache-Control", maxAgeHeader);
    }

    protected String getResourcePathFrom(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }
}

