/*
 * Decompiled with CFR 0.152.
 */
package org.n52.web.ctrl.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.handler.DatasetFactoryException;
import org.n52.io.handler.DefaultIoFactory;
import org.n52.io.handler.IoHandlerFactory;
import org.n52.io.handler.IoProcessChain;
import org.n52.io.request.IoParameters;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.request.RequestStyledParameterSet;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DataCollection;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.series.spi.srv.DataService;
import org.n52.series.spi.srv.ParameterService;
import org.n52.series.spi.srv.RawDataService;
import org.n52.web.ctrl.BaseController;
import org.n52.web.ctrl.data.DatasetsDataController;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

public abstract class DataController
extends BaseController {
    protected static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    protected static final String CONTENT_DISPOSITION_VALUE_TEMPLATE = "attachment; filename=\"Observations_for_Dataset_";
    protected static final String SHOWTIMEINTERVALS_QUERY_OPTION = "showTimeIntervals";
    protected static final String PROFILE = "profile";
    protected static final String OBSERVATIONS = "observations";
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetsDataController.class);
    private static final String DEFAULT_RESPONSE_ENCODING = "UTF-8";
    private final DefaultIoFactory<DatasetOutput<AbstractValue<?>>, AbstractValue<?>> ioFactoryCreator;
    private final DataService<Data<AbstractValue<?>>> dataService;
    private final ParameterService<DatasetOutput<AbstractValue<?>>> datasetService;
    @Value(value="${requestIntervalRestriction:P370D}")
    private String requestIntervalRestriction;

    @Autowired
    public DataController(DefaultIoFactory<DatasetOutput<AbstractValue<?>>, AbstractValue<?>> ioFactory, ParameterService<DatasetOutput<AbstractValue<?>>> datasetService, DataService<Data<AbstractValue<?>>> dataService) {
        this.ioFactoryCreator = ioFactory;
        this.datasetService = datasetService;
        this.dataService = dataService;
    }

    protected abstract String getValueType(IoParameters var1, String var2);

    protected ParameterService<DatasetOutput<AbstractValue<?>>> getDatasetService() {
        return this.datasetService;
    }

    @RequestMapping(value={"/{datasetId}/observations"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView getSeriesData(HttpServletRequest request, HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters map = this.createParameters(datasetId, query, locale, response);
        LOGGER.debug("get data for item '{}' with query: {}", (Object)datasetId, (Object)map);
        this.checkAgainstTimespanRestriction(map.getTimespan());
        this.checkForUnknownDatasetId(map.removeAllOf("bbox").removeAllOf("near"), datasetId);
        String valueType = this.getValueType(map, request.getRequestURI());
        IoProcessChain ioChain = this.createIoFactory(valueType).setParameters(map).createProcessChain();
        DataCollection formattedDataCollection = ioChain.getProcessedData();
        Map processed = formattedDataCollection.getAllSeries();
        return map.isExpanded() ? new ModelAndView().addObject((Object)processed) : new ModelAndView().addObject(processed.get(datasetId));
    }

    @RequestMapping(value={"/observations"}, produces={"application/json"}, method={RequestMethod.POST})
    public ModelAndView getCollectionData(HttpServletRequest request, HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestSimpleParameterSet simpleParameters) throws Exception {
        IoParameters parameters = this.createParameters(simpleParameters, locale, response);
        LOGGER.debug("get data collection with parameter set: {}", (Object)parameters);
        this.checkForUnknownDatasetIds(parameters, parameters.getDatasets());
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        String valueType = this.getValueType(parameters, request.getRequestURI());
        IoProcessChain ioChain = this.createIoFactory(valueType).setParameters(parameters).createProcessChain();
        DataCollection processed = ioChain.getData();
        return new ModelAndView().addObject((Object)processed.getAllSeries());
    }

    @RequestMapping(value={"/observations"}, params={"rawFormat"}, method={RequestMethod.POST})
    public void getRawSeriesCollectionData(HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestSimpleParameterSet simpleParameters) throws Exception {
        IoParameters parameters = this.createParameters(simpleParameters, locale, response);
        this.checkForUnknownDatasetIds(parameters, parameters.getDatasets());
        this.writeRawData(parameters, response);
    }

    @RequestMapping(value={"/{datasetId}/observations"}, method={RequestMethod.GET}, params={"rawFormat"})
    public void getRawSeriesData(HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam MultiValueMap<String, String> query) {
        IoParameters parameters = this.createParameters(datasetId, query, locale, response);
        this.checkForUnknownDatasetId(parameters, datasetId);
        this.writeRawData(parameters, response);
    }

    private void writeRawData(IoParameters parameters, HttpServletResponse response) throws InternalServerException, ResourceNotFoundException, BadRequestException {
        LOGGER.debug("get raw data collection with parameters: {}", (Object)parameters);
        if (!this.dataService.supportsRawData()) {
            throw new BadRequestException("Querying of raw timeseries data is not supported by the underlying service!");
        }
        RawDataService rawDataService = this.dataService.getRawDataService();
        try (InputStream inputStream = rawDataService.getRawData(parameters);){
            response.setContentType(parameters.getRawFormat());
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new InternalServerException("Error while querying raw data", e);
        }
    }

    @RequestMapping(value={"/observations"}, produces={"application/pdf"}, method={RequestMethod.POST})
    public void getSeriesCollectionReport(HttpServletRequest request, HttpServletResponse response, @RequestHeader(value="accept-language", required=false) String locale, @RequestBody RequestStyledParameterSet simpleParameters) throws Exception {
        IoParameters parameters = this.createParameters(simpleParameters, locale, response);
        LOGGER.debug("get data collection report with query: {}", (Object)parameters);
        this.checkForUnknownDatasetIds(parameters, parameters.getDatasets());
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        String valueType = this.getValueType(parameters, request.getRequestURI());
        String outputFormat = "application/pdf";
        response.setContentType(outputFormat);
        this.createIoFactory(valueType).setParameters(parameters).createHandler(outputFormat).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/observations"}, produces={"application/pdf"}, method={RequestMethod.GET})
    public void getSeriesReport(HttpServletRequest request, HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters parameters = this.createParameters(datasetId, query, locale, response);
        LOGGER.debug("get data collection report for '{}' with query: {}", (Object)datasetId, (Object)parameters);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkForUnknownDatasetId(parameters, datasetId);
        String valueType = this.getValueType(parameters, request.getRequestURI());
        String outputFormat = "application/pdf";
        response.setContentType(outputFormat);
        response.setHeader(CONTENT_DISPOSITION_HEADER, CONTENT_DISPOSITION_VALUE_TEMPLATE + datasetId + ".pdf\"");
        this.createIoFactory(valueType).setParameters(parameters).createHandler(outputFormat).writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/observations"}, produces={"application/zip"}, method={RequestMethod.GET})
    public void getSeriesAsZippedCsv(HttpServletRequest request, HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        query.putIfAbsent((Object)SHOWTIMEINTERVALS_QUERY_OPTION, Arrays.asList(Boolean.TRUE.toString()));
        IoParameters parameters = this.createParameters(datasetId, query, locale, response);
        LOGGER.debug("get data collection zip for '{}' with query: {}", (Object)datasetId, (Object)parameters);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkForUnknownDatasetId(parameters, datasetId);
        response.setCharacterEncoding(DEFAULT_RESPONSE_ENCODING);
        response.setContentType("application/zip");
        response.setHeader(CONTENT_DISPOSITION_HEADER, CONTENT_DISPOSITION_VALUE_TEMPLATE + datasetId + ".zip\"");
        String valueType = this.getValueType(parameters, request.getRequestURI());
        this.createIoFactory(valueType).setParameters(parameters).createHandler("application/zip").writeBinary((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/{datasetId}/observations"}, produces={"text/csv"}, method={RequestMethod.GET})
    public void getSeriesAsCsv(HttpServletRequest request, HttpServletResponse response, @PathVariable String datasetId, @RequestHeader(value="accept-language", required=false) String locale, @RequestParam(required=false) MultiValueMap<String, String> query) throws Exception {
        IoParameters parameters = this.createParameters(datasetId, query, locale, response);
        LOGGER.debug("get data collection csv for '{}' with query: {}", (Object)datasetId, (Object)parameters);
        this.checkAgainstTimespanRestriction(parameters.getTimespan());
        this.checkForUnknownDatasetId(parameters, datasetId);
        String extension = ".";
        response.setCharacterEncoding(DEFAULT_RESPONSE_ENCODING);
        if (Boolean.parseBoolean(parameters.getOther("zip"))) {
            response.setContentType("application/zip");
            extension = extension + "zip";
        } else {
            response.setContentType("text/csv");
            extension = extension + "csv";
        }
        response.setHeader(CONTENT_DISPOSITION_HEADER, CONTENT_DISPOSITION_VALUE_TEMPLATE + datasetId + extension + "\"");
        String valueType = this.getValueType(parameters, request.getRequestURI());
        this.createIoFactory(valueType).setParameters(parameters).createHandler("text/csv").writeBinary((OutputStream)response.getOutputStream());
    }

    protected void checkAgainstTimespanRestriction(IntervalWithTimeZone timespan) {
        Duration duration;
        if (this.requestIntervalRestriction != null && (duration = Period.parse((String)this.requestIntervalRestriction).toDurationFrom((ReadableInstant)new DateTime())).getMillis() < Interval.parse((String)timespan.toString()).toDurationMillis()) {
            throw new BadRequestException("Timespan too long, please use a period shorter than '" + this.requestIntervalRestriction + "'");
        }
    }

    protected void checkForUnknownDatasetId(IoParameters parameters, String seriesId) {
        this.checkForUnknownDatasetIds(parameters, Collections.singleton(seriesId));
    }

    protected void checkForUnknownDatasetIds(IoParameters parameters, Set<String> seriesIds) {
        if (seriesIds != null) {
            for (String id : seriesIds) {
                if (this.datasetService.exists(id, parameters)) continue;
                throw new ResourceNotFoundException("Series with id '" + id + "' wasn't found.");
            }
        }
    }

    protected IoHandlerFactory<DatasetOutput<AbstractValue<?>>, AbstractValue<?>> createIoFactory(String valueType) throws DatasetFactoryException {
        if (!this.ioFactoryCreator.isKnown(valueType)) {
            throw new ResourceNotFoundException("unknown dataset type: " + valueType);
        }
        return ((IoHandlerFactory)this.ioFactoryCreator.create(valueType)).setDataService(this.dataService).setDatasetService(this.datasetService);
    }

    @Override
    protected void addCacheHeader(IoParameters parameter, HttpServletResponse response) {
        parameter.getCache().map(node -> node.asLong(0L)).ifPresent(v -> this.addCacheHeader(response, (long)v));
    }

    protected boolean isProfileType(DatasetOutput<AbstractValue<?>> item) {
        String observationType = item.getObservationType();
        String datasetType = item.getDatasetType();
        return observationType.equals(PROFILE) || datasetType.equals(PROFILE);
    }

    protected DatasetOutput<AbstractValue<?>> getFirstDatasetOutput(IoParameters map) {
        return (DatasetOutput)this.datasetService.getCondensedParameters(map).getItem(0);
    }

    public String getRequestIntervalRestriction() {
        return this.requestIntervalRestriction;
    }

    public void setRequestIntervalRestriction(String requestIntervalRestriction) {
        Period.parse((String)requestIntervalRestriction);
        LOGGER.debug("CONFIG: request.interval.restriction={}", (Object)requestIntervalRestriction);
        this.requestIntervalRestriction = requestIntervalRestriction;
    }
}

