/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.crs;

import java.io.Serializable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.n52.io.crs.CRSUtils;

public class BoundingBox
implements Serializable {
    private static final long serialVersionUID = -674668726920006020L;
    private Point ll;
    private Point ur;
    private String srs;

    private BoundingBox() {
    }

    public BoundingBox(Point ll, Point ur, String srs) {
        this.ll = ll;
        this.ur = ur;
        this.srs = srs;
    }

    public boolean contains(Geometry geometry) {
        return geometry.getDimension() > 2 ? !geometry.contains((Geometry)this.ll) && !geometry.contains((Geometry)this.ur) : this.asEnvelop().contains(geometry.getEnvelopeInternal());
    }

    public Envelope asEnvelop() {
        return new Envelope(this.ll.getCoordinate(), this.ur.getCoordinate());
    }

    public void extendBy(Point point) {
        if (!this.contains((Geometry)point)) {
            CRSUtils crsUtils = CRSUtils.createEpsgForcedXYAxisOrder();
            this.ll = crsUtils.createPoint(Math.min(point.getX(), this.ll.getX()), Math.max(point.getX(), this.ur.getX()), this.srs);
            this.ur = crsUtils.createPoint(Math.min(point.getY(), this.ll.getY()), Math.max(point.getY(), this.ur.getY()), this.srs);
        }
    }

    public void setLl(Point ll) {
        this.ll = ll;
    }

    public void setUr(Point ur) {
        this.ur = ur;
    }

    public Point getLowerLeft() {
        return this.ll;
    }

    public Point getUpperRight() {
        return this.ur;
    }

    public String getSrs() {
        return this.srs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BBOX [ (");
        sb.append(this.ll.getX()).append(",").append(this.ll.getY()).append(");(");
        sb.append(this.ur.getX()).append(",").append(this.ur.getY()).append(") ");
        sb.append("srs: ").append(this.getSrs());
        return sb.append(" ]").toString();
    }
}

