/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.crs;

import org.locationtech.jts.geom.Point;

public class WGS84Util {
    public static final String EPSG_4326 = "EPSG:4326";
    protected static final double EARTH_MEAN_RADIUS = 6371.0;

    public static double shortestDistanceBetween(Point a, Point b) {
        double aXinRad = Math.toRadians(a.getX());
        double aYinRad = Math.toRadians(a.getY());
        double bXinRad = Math.toRadians(b.getX());
        double bYinRad = Math.toRadians(b.getY());
        double aProd = Math.sin(aYinRad) * Math.sin(bYinRad);
        double bProd = Math.cos(aYinRad) * Math.cos(bYinRad) * Math.cos(aXinRad - bXinRad);
        return Math.acos(aProd + bProd) * 6371.0;
    }

    public static double getLongitudeDelta(double latitude, double distance) {
        return Math.toDegrees(distance / WGS84Util.getLatitutesCircleRadius(latitude)) % 360.0;
    }

    public static double getLatitudeDelta(double distance) {
        return Math.toDegrees(distance / 6371.0) % 180.0;
    }

    static double getLatitutesCircleRadius(double latitude) {
        return 6371.0 * Math.sin(1.5707963267948966 - latitude);
    }

    public static double normalizeLongitude(double longitude) {
        double asRad = Math.toRadians(longitude);
        if (asRad > Math.PI) {
            return Math.toDegrees(Math.PI * -2 + asRad) % 180.0;
        }
        if (-Math.PI > asRad) {
            return Math.toDegrees(Math.PI * 2 + asRad) % 180.0;
        }
        return longitude;
    }

    public static double normalizeLatitude(double latitude) {
        double asRad = Math.toRadians(latitude);
        if (asRad > 1.5707963267948966) {
            return Math.toDegrees(Math.PI * 2 - asRad) % 90.0;
        }
        if (-1.5707963267948966 > asRad) {
            return Math.toDegrees(Math.PI * -2 - asRad) % 90.0;
        }
        return latitude;
    }
}

