/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.geojson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.n52.io.geojson.GeoJSONException;

public class GeoJSONEncoder {
    public static final int DEFAULT_SRID = 4326;
    public static final String SRID_LINK_PREFIX = "http://www.opengis.net/def/crs/EPSG/0/";
    private final JsonNodeFactory jsonFactory = JsonNodeFactory.withExactBigDecimals((boolean)false);

    public ObjectNode encodeGeometry(Geometry value) throws GeoJSONException {
        if (value == null) {
            return null;
        }
        return this.encodeGeometry(value, 4326);
    }

    public ObjectNode encodeGeometry(Geometry geometry, int parentSrid) throws GeoJSONException {
        if (geometry.isEmpty()) {
            return null;
        }
        if (geometry instanceof Point) {
            return this.encode((Point)geometry, parentSrid);
        }
        if (geometry instanceof LineString) {
            return this.encode((LineString)geometry, parentSrid);
        }
        if (geometry instanceof Polygon) {
            return this.encode((Polygon)geometry, parentSrid);
        }
        if (geometry instanceof MultiPoint) {
            return this.encode((MultiPoint)geometry, parentSrid);
        }
        if (geometry instanceof MultiLineString) {
            return this.encode((MultiLineString)geometry, parentSrid);
        }
        if (geometry instanceof MultiPolygon) {
            return this.encode((MultiPolygon)geometry, parentSrid);
        }
        if (geometry instanceof GeometryCollection) {
            return this.encode((GeometryCollection)geometry, parentSrid);
        }
        throw new GeoJSONException("unknown geometry type " + geometry.getGeometryType());
    }

    protected ObjectNode encode(Point geometry, int parentSrid) {
        ObjectNode json = this.jsonFactory.objectNode();
        json.put("type", "Point");
        json.set("coordinates", (JsonNode)this.encodeCoordinates(geometry));
        this.encodeCRS(json, (Geometry)geometry, parentSrid);
        return json;
    }

    protected ObjectNode encode(LineString geometry, int parentSrid) {
        ObjectNode json = this.jsonFactory.objectNode();
        json.put("type", "LineString");
        json.set("coordinates", (JsonNode)this.encodeCoordinates(geometry));
        this.encodeCRS(json, (Geometry)geometry, parentSrid);
        return json;
    }

    protected ObjectNode encode(Polygon geometry, int parentSrid) {
        ObjectNode json = this.jsonFactory.objectNode();
        json.put("type", "Polygon");
        json.set("coordinates", (JsonNode)this.encodeCoordinates(geometry));
        this.encodeCRS(json, (Geometry)geometry, parentSrid);
        return json;
    }

    protected ObjectNode encode(MultiPoint geometry, int parentSrid) {
        ObjectNode json = this.jsonFactory.objectNode();
        ArrayNode list = json.put("type", "MultiPoint").putArray("coordinates");
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            list.add((JsonNode)this.encodeCoordinates((Point)geometry.getGeometryN(i)));
        }
        this.encodeCRS(json, (Geometry)geometry, parentSrid);
        return json;
    }

    protected ObjectNode encode(MultiLineString geometry, int parentSrid) {
        ObjectNode json = this.jsonFactory.objectNode();
        ArrayNode list = json.put("type", "MultiLineString").putArray("coordinates");
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            list.add((JsonNode)this.encodeCoordinates((LineString)geometry.getGeometryN(i)));
        }
        this.encodeCRS(json, (Geometry)geometry, parentSrid);
        return json;
    }

    protected ObjectNode encode(MultiPolygon geometry, int parentSrid) {
        ObjectNode json = this.jsonFactory.objectNode();
        ArrayNode list = json.put("type", "MultiPolygon").putArray("coordinates");
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            list.add((JsonNode)this.encodeCoordinates((Polygon)geometry.getGeometryN(i)));
        }
        this.encodeCRS(json, (Geometry)geometry, parentSrid);
        return json;
    }

    public ObjectNode encode(GeometryCollection geometry, int parentSrid) throws GeoJSONException {
        ObjectNode json = this.jsonFactory.objectNode();
        ArrayNode geometries = json.put("type", "GeometryCollection").putArray("geometries");
        int srid = this.encodeCRS(json, (Geometry)geometry, parentSrid);
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            geometries.add((JsonNode)this.encodeGeometry(geometry.getGeometryN(i), srid));
        }
        return json;
    }

    protected ArrayNode encodeCoordinate(Coordinate coordinate) {
        ArrayNode array = this.jsonFactory.arrayNode().add(coordinate.x).add(coordinate.y);
        if (!Double.isNaN(coordinate.z)) {
            array.add(coordinate.z);
        }
        return array;
    }

    protected ArrayNode encodeCoordinates(CoordinateSequence coordinates) {
        ArrayNode list = this.jsonFactory.arrayNode();
        for (int i = 0; i < coordinates.size(); ++i) {
            list.add((JsonNode)this.encodeCoordinate(coordinates.getCoordinate(i)));
        }
        return list;
    }

    protected ArrayNode encodeCoordinates(Point geometry) {
        return this.encodeCoordinate(geometry.getCoordinate());
    }

    protected ArrayNode encodeCoordinates(LineString geometry) {
        return this.encodeCoordinates(geometry.getCoordinateSequence());
    }

    protected ArrayNode encodeCoordinates(Polygon geometry) {
        ArrayNode list = this.jsonFactory.arrayNode();
        list.add((JsonNode)this.encodeCoordinates(geometry.getExteriorRing()));
        for (int i = 0; i < geometry.getNumInteriorRing(); ++i) {
            list.add((JsonNode)this.encodeCoordinates(geometry.getInteriorRingN(i)));
        }
        return list;
    }

    protected int encodeCRS(ObjectNode json, Geometry geometry, int parentSrid) {
        return this.encodeCRS(geometry.getSRID(), parentSrid, json);
    }

    protected int encodeCRS(int srid, int parentSrid, ObjectNode json) {
        if (srid == parentSrid || srid == 0 || parentSrid == 4326 && srid == 4326) {
            return parentSrid;
        }
        json.putObject("crs").put("type", "link").putObject("properties").put("href", SRID_LINK_PREFIX + srid);
        return srid;
    }
}

