/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.geojson;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONUtils.class);
    private static final JsonNodeFactory FACTORY = JsonNodeFactory.withExactBigDecimals((boolean)false);
    private static final ObjectReader READER;
    private static final ObjectWriter WRITER;

    protected JSONUtils() {
    }

    public static ObjectReader getReader() {
        return READER;
    }

    public static ObjectWriter getWriter() {
        return WRITER;
    }

    public static JsonNodeFactory nodeFactory() {
        return FACTORY;
    }

    public static String print(JsonNode node) {
        StringWriter writer = new StringWriter();
        try {
            JSONUtils.print(writer, node);
            writer.flush();
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ioe) {
                LOGGER.error("Error while colsing closeable!", (Throwable)ioe);
            }
        }
        return writer.toString();
    }

    public static void print(Writer writer, JsonNode node) throws IOException {
        JSONUtils.getWriter().writeValue(writer, (Object)node);
    }

    public static void print(OutputStream writer, JsonNode node) throws IOException {
        JSONUtils.getWriter().writeValue(writer, (Object)node);
    }

    public static JsonNode loadURL(URL url) throws IOException {
        return JSONUtils.getReader().readTree(url.openStream());
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Ignore false positive")
    public static JsonNode loadPath(String path) throws IOException {
        try (FileInputStream in = new FileInputStream(path);){
            JsonNode jsonNode = JSONUtils.getReader().readTree((InputStream)in);
            return jsonNode;
        }
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Ignore false positive")
    public static JsonNode loadFile(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            JsonNode jsonNode = JSONUtils.getReader().readTree((InputStream)in);
            return jsonNode;
        }
    }

    public static JsonNode loadStream(InputStream in) throws IOException {
        return JSONUtils.getReader().readTree(in);
    }

    public static JsonNode loadReader(Reader reader) throws IOException {
        return JSONUtils.getReader().readTree(reader);
    }

    public static JsonNode loadString(String json) {
        try {
            return JSONUtils.loadReader(new StringReader(json));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        ObjectMapper mapper = new ObjectMapper().setNodeFactory(FACTORY).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        READER = mapper.reader();
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter();
        pp.indentArraysWith((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n"));
        WRITER = mapper.writer((PrettyPrinter)pp);
    }
}

