/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.n52.io.geojson.GeoJSONDecoder;
import org.n52.io.geojson.GeoJSONException;
import org.n52.io.request.BBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BBoxDeserializer
extends JsonDeserializer<BBox> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BBoxDeserializer.class);

    public BBox deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        Point ll = (Point)this.decodeGeometry(this.getLowerLeft(node));
        Point ur = (Point)this.decodeGeometry(this.getUpperRight(node));
        return new BBox(ll, ur);
    }

    private JsonNode getLowerLeft(JsonNode node) {
        return this.getObjectNode("ll", node);
    }

    private JsonNode getUpperRight(JsonNode node) {
        return this.getObjectNode("ur", node);
    }

    private JsonNode getObjectNode(String path, JsonNode node) {
        return !node.path(path).isObject() ? MissingNode.getInstance() : node.path(path);
    }

    private Geometry decodeGeometry(JsonNode value) {
        try {
            GeoJSONDecoder dec = new GeoJSONDecoder();
            return dec.decodeGeometry(value);
        }
        catch (GeoJSONException e) {
            LOGGER.error("could not properly decode geometry.", (Throwable)e);
            return null;
        }
    }
}

