/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import java.util.Set;
import org.n52.io.request.IoParameters;

public class FilterResolver {
    private static final String ALL = "all";
    private final IoParameters parameters;

    public FilterResolver(IoParameters parameters) {
        this.parameters = parameters;
    }

    boolean shallBehaveBackwardsCompatible() {
        return false;
    }

    public boolean hasMobileFilter() {
        return this.parameters.getMobile() != null;
    }

    public boolean hasInsituFilter() {
        return this.parameters.getInsitu() != null;
    }

    public boolean isMobileFilter() {
        return this.hasMobileFilter() && Boolean.parseBoolean(this.parameters.getMobile());
    }

    public boolean isInsituFilter() {
        return this.hasInsituFilter() && Boolean.parseBoolean(this.parameters.getInsitu());
    }

    public boolean shallIncludeAllDatasets() {
        return !this.hasMobileFilter() && !this.hasInsituFilter();
    }

    public boolean isSetPlatformTypeFilter() {
        return !this.getDatasets().isEmpty();
    }

    @Deprecated
    private Set<String> getDatasets() {
        return this.parameters.getDatasets();
    }

    private Set<String> getObservedGeometryTypes() {
        return this.parameters.getObservedGeometryTypes();
    }

    private Set<String> getPlatformGeometryTypes() {
        return this.parameters.getPlatformGeometryTypes();
    }

    public boolean shallIncludeAllDatasetTypes() {
        Set<String> types = this.parameters.getDatasetTypes();
        return !this.isSetDatasetTypeFilter() && !this.isSetObservationTypeFilter() && !this.isSetValueTypeFilter() || types.contains(ALL);
    }

    public boolean shallIncludeDatasetType(String datasetType) {
        Set<String> datasetTypes = this.parameters.getDatasetTypes();
        return datasetTypes.contains(datasetType) || datasetTypes.contains(ALL);
    }

    public boolean shallIncludeAllObservationTypes() {
        Set<String> types = this.parameters.getObservationTypes();
        return !this.isSetObservationTypeFilter() || types.contains(ALL);
    }

    public boolean shallIncludeObservationType(String observationType) {
        Set<String> observationTypes = this.parameters.getObservationTypes();
        return observationTypes.contains(observationType) || observationTypes.contains(ALL);
    }

    public boolean shallIncludeAllValueTypes() {
        Set<String> types = this.parameters.getValueTypes();
        return !this.isSetValueTypeFilter() || types.contains(ALL);
    }

    public boolean shallIncludeValueType(String valueType) {
        Set<String> valueTypes = this.parameters.getValueTypes();
        return valueTypes.contains(valueType) || valueTypes.contains(ALL);
    }

    private boolean isSetDatasetTypeFilter() {
        return !this.parameters.getDatasetTypes().isEmpty();
    }

    private boolean isSetObservationTypeFilter() {
        return !this.parameters.getObservationTypes().isEmpty();
    }

    private boolean isSetValueTypeFilter() {
        return !this.parameters.getValueTypes().isEmpty();
    }
}

