/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.locationtech.jts.geom.Point;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.IoParseException;
import org.n52.io.crs.BoundingBox;
import org.n52.io.crs.CRSUtils;
import org.n52.io.request.BBox;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.Parameters;
import org.n52.io.request.StyleProperties;
import org.n52.io.request.Vicinity;
import org.n52.shetland.ogc.filter.Filter;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.odata.ODataFesParser;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class IoParameters
implements Parameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoParameters.class);
    private static final String DEFAULT_CONFIG_FILE = "config-general.json";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ODataFesParser ODATA_PARSER = new ODataFesParser();
    private static final String QUANTITY = "quantity";
    private final MultiValueMap<String, JsonNode> query;
    private final FilterResolver filterResolver;
    private boolean behaveBackwardsCompatible;
    private BiConsumer<String, IoParseException> parseExceptionHandle;

    protected IoParameters() {
        this(Collections.emptyMap());
    }

    protected IoParameters(IoParameters other) {
        this(other.query);
    }

    protected IoParameters(Map<String, JsonNode> queryParameters) {
        this(queryParameters, (File)null);
    }

    protected IoParameters(Map<String, JsonNode> queryParameters, File defaults) {
        this(defaults);
        this.query.setAll(this.mergeToLowerCasedKeys(queryParameters));
    }

    protected IoParameters(MultiValueMap<String, JsonNode> queryParameters) {
        this(queryParameters, (File)null);
    }

    protected IoParameters(MultiValueMap<String, JsonNode> queryParameters, File defaults) {
        this(defaults);
        if (queryParameters != null) {
            this.query.putAll(this.mergeToLowerCasedKeys(queryParameters));
        }
    }

    private IoParameters(File defaultConfig) {
        LinkedMultiValueMap config = new LinkedMultiValueMap();
        config.setAll(this.readDefaultConfig(defaultConfig));
        this.query = this.mergeToLowerCasedKeys((MultiValueMap<String, JsonNode>)config);
        this.filterResolver = new FilterResolver(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, JsonNode> readDefaultConfig(File config) {
        try (InputStream stream = config == null ? IoParameters.getDefaultConfigFile() : new FileInputStream(config);){
            Map map = (Map)OBJECT_MAPPER.readValue(stream, (JavaType)TypeFactory.defaultInstance().constructMapLikeType(HashMap.class, String.class, JsonNode.class));
            return map;
        }
        catch (IOException e) {
            LOGGER.trace("Could not load '{}'", (Object)DEFAULT_CONFIG_FILE, (Object)e);
            LOGGER.info("Config could not be loaded (switch to TRACE to see details).");
            return new HashMap<String, JsonNode>();
        }
    }

    private static InputStream getDefaultConfigFile() {
        try {
            Path path = Paths.get(IoParameters.class.getResource("/").toURI());
            File config = path.resolve(DEFAULT_CONFIG_FILE).toFile();
            String fallbackPath = "/config-general.json";
            return config.exists() ? new FileInputStream(config) : IoParameters.class.getClassLoader().getResourceAsStream("/config-general.json");
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.debug("Could not find default config under '{}'", (Object)DEFAULT_CONFIG_FILE, (Object)e);
            return null;
        }
    }

    public boolean shallBehaveBackwardsCompatible() {
        return this.behaveBackwardsCompatible;
    }

    private IoParameters setBehaveBackwardsCompatible(boolean behaveBackwardsCompatible) {
        this.behaveBackwardsCompatible = behaveBackwardsCompatible;
        return this;
    }

    public IoParameters setParseExceptionHandle(BiConsumer<String, IoParseException> handle) {
        this.parseExceptionHandle = handle;
        return this;
    }

    public int getOffset() {
        return this.getAsInteger("offset", -1);
    }

    public int getLimit() {
        return this.getAsInteger("limit", -1);
    }

    public int getWidth() {
        return this.getAsInteger("width", 800);
    }

    public int getHeight() {
        return this.getAsInteger("height", 500);
    }

    public boolean isBase64() {
        return this.getAsBoolean("base64", false);
    }

    public boolean isGrid() {
        return this.getAsBoolean("grid", true);
    }

    public boolean isGeneralize() {
        return this.getAsBoolean("generalize", false);
    }

    public boolean isLegend() {
        return this.getAsBoolean("legend", false);
    }

    public String getLocale() {
        return this.getAsString("locale", "en");
    }

    public StyleProperties getSingleStyle() {
        return this.containsParameter("style") ? this.parseStyleProperties() : StyleProperties.createDefaults();
    }

    public Map<String, StyleProperties> getReferencedStyles() {
        return this.containsParameter("styles") ? this.parseMultipleStyleProperties() : Collections.emptyMap();
    }

    public boolean hasStyles() {
        return this.getSingleStyle() != null || !this.getReferencedStyles().isEmpty();
    }

    private StyleProperties parseStyleProperties() {
        return this.handleJsonValueParseException("style", StyleProperties.class, this::parseJson);
    }

    private Map<String, StyleProperties> parseMultipleStyleProperties() {
        return this.handleJsonValueParseException("styles", new TypeReference<HashMap<String, StyleProperties>>(){}, this::parseJson);
    }

    public String getFormat() {
        return this.getAsString("format", "tvp");
    }

    public boolean isSetRawFormat() {
        return this.containsParameter("rawFormat");
    }

    public String getRawFormat() {
        if (this.isSetRawFormat()) {
            JsonNode value = (JsonNode)this.query.getFirst((Object)"rawFormat");
            return value != null ? value.asText() : null;
        }
        return null;
    }

    public String getTimeFormat() {
        return this.getAsString("timeformat", "yyyy-MM-dd, HH:mm");
    }

    public IntervalWithTimeZone getTimespan() {
        return this.containsParameter("timespan") ? this.validateTimespan(this.getNormalizedTimespan()) : IoParameters.createDefaultTimespan();
    }

    private String getNormalizedTimespan() {
        return this.getNormalizedTimespan(null);
    }

    protected String getNormalizedTimespan(DateTimeFormatter dateFormat) {
        String parameterValue = this.getAsString("timespan");
        String now = dateFormat == null ? new DateTime().toString() : dateFormat.print((ReadableInstant)new DateTime());
        return parameterValue.replaceAll("(?i)now", now);
    }

    public static IntervalWithTimeZone createDefaultTimespan() {
        DateTime now = new DateTime();
        DateTime lastWeek = now.minusWeeks(1);
        String interval = lastWeek.toString().concat("/").concat(now.toString());
        return new IntervalWithTimeZone(interval);
    }

    private IntervalWithTimeZone validateTimespan(String timespan) {
        try {
            return new IntervalWithTimeZone(timespan);
        }
        catch (IllegalArgumentException e) {
            IoParseException ex = new IoParseException(e.getMessage(), e);
            throw ex.addHint("Valid timespans have to be in ISO8601 period format.").addHint("Valid examples: 'PT6H/2013-08-13TZ' or '2013-07-13TZ/2013-08-13TZ'.");
        }
    }

    public String getOutputTimezone() {
        if (!this.containsParameter("outputTimezone")) {
            return "UTC";
        }
        String timezone = this.getAsString("outputTimezone");
        Set availableIDs = DateTimeZone.getAvailableIDs();
        DateTimeZone zone = availableIDs.contains(timezone) ? DateTimeZone.forID((String)timezone) : DateTimeZone.UTC;
        return zone.toString();
    }

    public Instant getResultTime() {
        if (!this.containsParameter("resultTime")) {
            return null;
        }
        return this.validateTimestamp(this.getAsString("resultTime"));
    }

    public boolean shallClassifyByResultTimes() {
        return this.isAllResultTimes() || !this.getResultTimes().isEmpty();
    }

    public boolean isAllResultTimes() {
        Set<String> resultTimes = this.csvToLowerCasedSet(this.getAsString("resultTimes"));
        return resultTimes.contains("all");
    }

    public Set<String> getResultTimes() {
        Set<String> resultTimes = this.csvToSet(this.getAsString("resultTimes"));
        if (resultTimes.contains("all")) {
            resultTimes.remove("all");
        }
        resultTimes.stream().forEach(this::validateTimestamp);
        Instant fromOldParameter = this.getResultTime();
        if (fromOldParameter != null) {
            resultTimes.add(fromOldParameter.toString());
        }
        return resultTimes;
    }

    private Instant validateTimestamp(String timestamp) {
        return this.handleSimpleValueParseException(timestamp, Instant::parse);
    }

    public Optional<Filter<?>> getODataFilter() {
        if (!this.containsParameter("$filter")) {
            return Optional.empty();
        }
        String parameter = this.getAsString("$filter");
        if (parameter.trim().isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(ODATA_PARSER.decode(parameter));
        }
        catch (DecodingException ex) {
            this.handleIoParseException("$filter", this.createIoParseException("$filter", (Exception)((Object)ex)));
            return Optional.empty();
        }
    }

    @Deprecated
    public String getCategory() {
        return this.getAsString("category");
    }

    @Deprecated
    public String getService() {
        return this.getAsString("service");
    }

    @Deprecated
    public String getOffering() {
        return this.getAsString("offering");
    }

    @Deprecated
    public String getFeature() {
        return this.getAsString("feature");
    }

    @Deprecated
    public String getProcedure() {
        return this.getAsString("procedure");
    }

    @Deprecated
    public String getPhenomenon() {
        return this.getAsString("phenomenon");
    }

    @Deprecated
    public String getStation() {
        return this.getAsString("station");
    }

    public Set<String> getCategories() {
        Set<String> values = this.getValuesOf("categories");
        values.addAll(this.getValuesOf("category"));
        return values;
    }

    public Set<String> getServices() {
        Set<String> values = this.getValuesOf("services");
        values.addAll(this.getValuesOf("service"));
        return values;
    }

    public Set<String> getOfferings() {
        Set<String> values = this.getValuesOf("offerings");
        values.addAll(this.getValuesOf("offering"));
        return values;
    }

    public Set<String> getFeatures() {
        Set<String> values = this.getValuesOf("features");
        values.addAll(this.getValuesOf("feature"));
        return values;
    }

    public Set<String> getProcedures() {
        Set<String> values = this.getValuesOf("procedures");
        values.addAll(this.getValuesOf("procedure"));
        return values;
    }

    public Set<String> getPhenomena() {
        Set<String> values = this.getValuesOf("phenomena");
        values.addAll(this.getValuesOf("phenomenon"));
        return values;
    }

    public Set<String> getStations() {
        Set<String> values = this.getValuesOf("stations");
        values.addAll(this.getValuesOf("station"));
        return values;
    }

    public Set<String> getPlatforms() {
        return this.getValuesOf("platforms");
    }

    public Set<String> getTimeseries() {
        return this.getSeries();
    }

    public Set<String> getSeries() {
        Set<String> values = this.getValuesOf("series");
        values.addAll(this.getValuesOf("timeseries"));
        return values;
    }

    public Set<String> getDatasets() {
        Set<String> values = this.getSeries();
        values.addAll(this.getValuesOf("datasets"));
        return values;
    }

    public Set<String> getFields() {
        return this.getValuesOf("fields");
    }

    public Set<String> getPlatformGeometryTypes() {
        return this.getValuesOf("platformGeometries");
    }

    public Set<String> getObservedGeometryTypes() {
        return this.getValuesOf("observedGeometries");
    }

    public String getMobile() {
        return this.getAsString("mobile");
    }

    public String getInsitu() {
        return this.getAsString("insitu");
    }

    public Set<String> getDatasetTypes() {
        return this.getValuesOf("datasetTypes");
    }

    public Set<String> getObservationTypes() {
        return this.getValuesOf("observationTypes");
    }

    public Set<String> getValueTypes() {
        return this.getValuesOf("valueTypes");
    }

    public Set<String> getSearchTerms() {
        return this.getValuesOf("q");
    }

    public Set<String> getGeometryTypes() {
        return this.getValuesOf("geometryTypes");
    }

    Set<String> getValuesOf(String parameterName) {
        return this.containsParameter(parameterName) ? new HashSet<String>(this.csvToLowerCasedSet(this.getAsString(parameterName))) : new HashSet(0);
    }

    private Set<String> csvToLowerCasedSet(String csv) {
        return this.csvToSet(csv, String::toLowerCase);
    }

    private Set<String> csvToSet(String csv) {
        return this.csvToSet(csv, Function.identity());
    }

    private <O> Set<O> csvToSet(String csv, Function<String, O> c) {
        return Optional.ofNullable(csv).map(str -> str.split(",")).flatMap(values -> Optional.ofNullable(c).map(f -> Arrays.stream(values).map(f).collect(Collectors.toSet()))).orElseGet(HashSet::new);
    }

    public FilterResolver getFilterResolver() {
        return this.filterResolver;
    }

    public BoundingBox getSpatialFilter() {
        if (!this.containsParameter("near") && !this.containsParameter("bbox")) {
            return null;
        }
        BoundingBox bboxBounds = this.createBbox();
        BoundingBox bounds = this.parseBoundsFromVicinity();
        return this.mergeBounds(bounds, bboxBounds);
    }

    private BoundingBox mergeBounds(BoundingBox bounds, BoundingBox bboxBounds) {
        if (bboxBounds == null) {
            return bounds;
        }
        Point lowerLeft = bboxBounds.getLowerLeft();
        Point upperRight = bboxBounds.getUpperRight();
        if (bounds == null) {
            BoundingBox parsed = new BoundingBox(lowerLeft, upperRight, "CRS:84");
            LOGGER.debug("Parsed bbox bounds: {}", (Object)parsed.toString());
            return parsed;
        }
        this.extendBy(lowerLeft, bounds);
        this.extendBy(upperRight, bounds);
        LOGGER.debug("Merged bounds: {}", (Object)bounds.toString());
        return bounds;
    }

    private void extendBy(Point point, BoundingBox bbox) {
        bbox.extendBy(point);
    }

    private BoundingBox createBbox() {
        if (!this.containsParameter("bbox")) {
            return null;
        }
        String bboxValue = this.getAsString("bbox");
        CRSUtils crsUtils = CRSUtils.createEpsgForcedXYAxisOrder();
        if (bboxValue.matches("^(-?\\d*\\.?\\d*\\,\\s*){3}(-?\\d*\\.?\\d*)\\s*$")) {
            String[] coordArray = bboxValue.split("\\,");
            Point lowerLeft = crsUtils.createPoint(Double.valueOf(coordArray[0].trim()), Double.valueOf(coordArray[1].trim()), "CRS:84");
            Point upperRight = crsUtils.createPoint(Double.valueOf(coordArray[2].trim()), Double.valueOf(coordArray[3].trim()), "CRS:84");
            return new BoundingBox(lowerLeft, upperRight, "CRS:84");
        }
        try {
            BBox bbox = this.handleJsonValueParseException("bbox", BBox.class, this::parseJson);
            return new BoundingBox(bbox.getLl(), bbox.getUr(), "CRS:84");
        }
        catch (IoParseException e) {
            throw e.addHint(this.createInvalidParameterMessage("bbox")).addHint("Check http://epsg-registry.org for EPSG CRS definitions and codes.").addHint("(alternate format of 'llLon,llLat,urLon,urLat' couldn't be detected)");
        }
    }

    private BoundingBox parseBoundsFromVicinity() {
        if (!this.containsParameter("near")) {
            return null;
        }
        Vicinity vicinity = this.handleJsonValueParseException("near", Vicinity.class, this::parseJson);
        if (this.containsParameter("crs")) {
            vicinity.setCenter(this.convertToCrs84(vicinity.getCenter()));
        }
        BoundingBox bounds = vicinity.calculateBounds();
        LOGGER.debug("Parsed vicinity bounds: {}", (Object)bounds.toString());
        return bounds;
    }

    private <T> T parseJson(String parameter, Class<T> clazz) {
        try {
            String value = this.getAsString(parameter);
            return (T)OBJECT_MAPPER.readValue(value, clazz);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw this.createInvalidJsonValueException(parameter, (Exception)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private <T> T parseJson(String parameter, TypeReference<T> typeReference) {
        try {
            Optional<JsonNode> value = this.getAsNode(parameter);
            return (T)(value.isPresent() ? OBJECT_MAPPER.readerFor(typeReference).readValue(value.get()) : null);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw this.createInvalidJsonValueException(parameter, (Exception)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private IoParseException createInvalidJsonValueException(String nodeValue, Exception e) {
        return new IoParseException("The given JSON value is invalid: " + nodeValue, e);
    }

    private Point convertToCrs84(Point point) {
        return this.isForceXY() ? this.transformToInnerCrs(point, CRSUtils.createEpsgForcedXYAxisOrder()) : this.transformToInnerCrs(point, CRSUtils.createEpsgStrictAxisOrder());
    }

    private Point transformToInnerCrs(Point point, CRSUtils crsUtils) {
        try {
            return crsUtils.transformOuterToInner(point, this.getCrs());
        }
        catch (TransformException e) {
            throw new IoParseException("Could not transform to internally used CRS:84.", e);
        }
        catch (FactoryException e) {
            throw new IoParseException("Check if 'crs' parameter is a valid EPSG CRS. Was: '" + this.getCrs() + "'.", e);
        }
    }

    public String getCrs() {
        return this.getAsString("crs", "CRS:84");
    }

    public boolean isForceXY() {
        return this.getAsBoolean("forceXY", false);
    }

    public boolean isMatchDomainIds() {
        return this.getAsBoolean("matchDomainIds", false);
    }

    public boolean isExpanded() {
        return this.getAsBoolean("expanded", false);
    }

    public boolean isForceLatestValueRequests() {
        return this.getAsBoolean("force_latest_values", false);
    }

    @Deprecated
    public boolean isStatusIntervalsRequests() {
        return this.getAsBoolean("status_intervals", false);
    }

    @Deprecated
    public boolean isRenderingHintsRequests() {
        return this.getAsBoolean("rendering_hints", false);
    }

    public String getHrefBase() {
        return this.getAsString("internal.href.base");
    }

    public boolean isShowTimeIntervals() {
        return this.getAsBoolean("showTimeIntervals", false);
    }

    public boolean isShowVerticalIntervals() {
        return this.getAsBoolean("showVerticalIntervals", false);
    }

    public boolean containsParameter(String parameter) {
        return this.query.containsKey((Object)parameter.toLowerCase()) || this.query.containsKey((Object)parameter);
    }

    public String getOther(String parameter) {
        return this.getAsString(parameter);
    }

    public String getAsString(String parameter, String defaultValue) {
        return this.containsParameter(parameter) ? this.getAsString(parameter) : defaultValue;
    }

    public String getAsString(String parameter) {
        if (!this.containsParameter(parameter)) {
            return null;
        }
        return this.asCsv(this.getAsNodes(parameter));
    }

    private Optional<JsonNode> getAsNode(String parameter) {
        return this.getAsNodes(parameter).stream().findFirst();
    }

    private List<JsonNode> getAsNodes(String parameter) {
        return this.query.get((Object)parameter) == null ? (List)this.query.get((Object)parameter.toLowerCase()) : (List)this.query.get((Object)parameter);
    }

    private String asCsv(List<JsonNode> list) {
        StringBuilder sb = new StringBuilder();
        for (JsonNode jsonNode : list) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(jsonNode.asText());
        }
        return sb.toString();
    }

    public int getAsInteger(String parameter, int defaultValue) {
        return this.containsParameter(parameter) ? this.handleSimpleValueParseException(parameter, this::getAsInteger) : defaultValue;
    }

    public int getAsInteger(String parameter) {
        try {
            String value = this.getAsString(parameter);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw this.createIoParseException(parameter).addHint("Value must be an integer!");
        }
    }

    public boolean getAsBoolean(String parameter, boolean defaultValue) {
        return this.containsParameter(parameter) ? this.handleSimpleValueParseException(parameter, this::getAsBoolean) : defaultValue;
    }

    public boolean getAsBoolean(String parameter) {
        String value = this.getAsString(parameter);
        if (Boolean.toString(true).equalsIgnoreCase(value) || Boolean.toString(false).equalsIgnoreCase(value)) {
            return Boolean.parseBoolean(value);
        }
        IoParseException ex = this.createIoParseException(parameter).addHint("Value must be either 'false' or 'true'!");
        return (Boolean)this.handleIoParseException(parameter, ex);
    }

    private IoParseException createIoParseException(String parameter) {
        return this.createIoParseException(parameter, null);
    }

    private IoParseException createIoParseException(String parameter, Exception e) {
        return e != null ? new IoParseException(this.createInvalidParameterMessage(parameter), e) : new IoParseException(this.createInvalidParameterMessage(parameter));
    }

    private String createInvalidParameterMessage(String parameter) {
        return "The parameter '" + parameter + "' is invalid.";
    }

    private <R> R handleSimpleValueParseException(String parameter, Function<String, R> supplier) {
        try {
            return supplier.apply(parameter);
        }
        catch (IoParseException e) {
            return this.handleIoParseException(parameter, e);
        }
    }

    private <R, T> R handleJsonValueParseException(String parameter, Class<T> clazz, BiFunction<String, Class<T>, R> supplier) {
        try {
            return supplier.apply(parameter, clazz);
        }
        catch (IoParseException e) {
            return this.handleIoParseException(parameter, e);
        }
    }

    private <R, T> R handleJsonValueParseException(String parameter, TypeReference<T> reference, BiFunction<String, TypeReference<T>, R> supplier) {
        try {
            return supplier.apply(parameter, reference);
        }
        catch (IoParseException e) {
            return this.handleIoParseException(parameter, e);
        }
    }

    private <R> R handleIoParseException(String parameter, IoParseException e) {
        if (this.parseExceptionHandle != null) {
            this.parseExceptionHandle.accept(parameter, e);
            return null;
        }
        throw e;
    }

    public static JsonNode getJsonNodeFrom(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString(object));
        }
        catch (IOException e) {
            LOGGER.error("Could not parse parameter", (Throwable)e);
            return null;
        }
    }

    public IoParameters removeAllOf(String key) {
        LinkedMultiValueMap newValues = new LinkedMultiValueMap(this.query);
        newValues.remove((Object)key.toLowerCase());
        return new IoParameters((MultiValueMap<String, JsonNode>)newValues).setParseExceptionHandle(this.parseExceptionHandle);
    }

    public IoParameters extendWith(String key, String ... values) {
        return values == null ? this.extendWith(key, Collections.emptyList()) : this.extendWith(key, Arrays.asList(values));
    }

    public IoParameters extendWith(String key, List<String> values) {
        LinkedMultiValueMap newValues = new LinkedMultiValueMap();
        newValues.put((Object)key.toLowerCase(), values);
        LinkedMultiValueMap mergedValues = new LinkedMultiValueMap(this.query);
        mergedValues.putAll(IoParameters.convertToJsonNodes((MultiValueMap<String, String>)newValues));
        return new IoParameters((MultiValueMap<String, JsonNode>)mergedValues).setParseExceptionHandle(this.parseExceptionHandle);
    }

    public IoParameters replaceWith(String key, String ... values) {
        return this.removeAllOf(key).extendWith(key, values);
    }

    public IoParameters replaceWith(String key, List<String> values) {
        return this.removeAllOf(key).extendWith(key, values);
    }

    protected static Map<String, JsonNode> convertValuesToJsonNodes(Map<String, String> queryParameters) {
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
            String key = entry.getKey();
            parameters.put(key.toLowerCase(), IoParameters.getJsonNodeFrom(entry.getValue()));
        }
        return parameters;
    }

    protected static MultiValueMap<String, JsonNode> convertToJsonNodes(MultiValueMap<String, String> queryParameters) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        Set entrySet = queryParameters.entrySet();
        for (Map.Entry entry : entrySet) {
            for (String value : (List)entry.getValue()) {
                String key = ((String)entry.getKey()).toLowerCase();
                parameters.add((Object)key, (Object)IoParameters.getJsonNodeFrom(value));
            }
        }
        return parameters;
    }

    public String toString() {
        return "IoParameters{ behaveBackwardsCompatible: " + this.behaveBackwardsCompatible + ", query=" + this.query + '}';
    }

    protected Map<String, JsonNode> mergeToLowerCasedKeys(Map<String, JsonNode> parameters) {
        HashMap<String, JsonNode> queryParameters = new HashMap<String, JsonNode>();
        for (Map.Entry<String, JsonNode> entry : parameters.entrySet()) {
            String parameter = entry.getKey();
            String lowerCasedKey = parameter.toLowerCase();
            queryParameters.put(lowerCasedKey, parameters.get(parameter));
        }
        return queryParameters;
    }

    protected MultiValueMap<String, JsonNode> mergeToLowerCasedKeys(MultiValueMap<String, JsonNode> parameters) {
        LinkedMultiValueMap queryParameters = new LinkedMultiValueMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String parameter = (String)entry.getKey();
            String lowerCasedKey = parameter.toLowerCase();
            List values = (List)parameters.get((Object)parameter);
            if (!queryParameters.containsKey((Object)lowerCasedKey)) {
                queryParameters.put((Object)lowerCasedKey, (Object)values);
                continue;
            }
            List currentValues = (List)queryParameters.get((Object)lowerCasedKey);
            if (currentValues == null) {
                queryParameters.put((Object)lowerCasedKey, (Object)values);
                continue;
            }
            currentValues.addAll(values);
        }
        return queryParameters;
    }

    public static IoParameters createDefaults() {
        return IoParameters.createDefaults(null);
    }

    public static IoParameters createDefaults(File defaultConfig) {
        return new IoParameters(Collections.emptyMap(), defaultConfig);
    }

    public static IoParameters createFromMultiValueMap(MultiValueMap<String, String> query) {
        return IoParameters.createFromMultiValueMap(query, null);
    }

    private static IoParameters createFromMultiValueMap(MultiValueMap<String, String> query, File defaultConfig) {
        return IoParameters.createFromMultiJsonValueMap(IoParameters.convertToJsonNodes(query), defaultConfig);
    }

    private static IoParameters createFromMultiJsonValueMap(MultiValueMap<String, JsonNode> query, File defaultConfig) {
        return new IoParameters(query, defaultConfig);
    }

    public static IoParameters createFromSingleValueMap(Map<String, String> query) {
        return IoParameters.createFromSingleValueMap(query, null);
    }

    private static IoParameters createFromSingleValueMap(Map<String, String> query, File defaultConfig) {
        return IoParameters.createFromSingleJsonValueMap(IoParameters.convertValuesToJsonNodes(query), defaultConfig);
    }

    static IoParameters createFromSingleJsonValueMap(Map<String, JsonNode> query) {
        return new IoParameters(query, null);
    }

    private static IoParameters createFromSingleJsonValueMap(Map<String, JsonNode> query, File defaultConfig) {
        return new IoParameters(query, defaultConfig);
    }

    public IoParameters respectBackwardsCompatibility() {
        return this.filterResolver.shallBehaveBackwardsCompatible() ? this.removeAllOf("internal.href.base").extendWith("mobile", Boolean.toString(false)).extendWith("insitu", Boolean.toString(true)).extendWith("valueTypes", QUANTITY).extendWith("observationTypes", "simple").extendWith("datasetTypes", "timeseries").setBehaveBackwardsCompatible(true) : this;
    }

    public boolean isPureStationaryInsituQuery() {
        Set<String> datasetTypes = this.getValueTypes();
        return this.isStationaryInsituOnly() && this.isQuantityOnly(datasetTypes);
    }

    private boolean isStationaryInsituOnly() {
        return this.getMobile() != null && this.getMobile().equals(Boolean.toString(false)) && this.getInsitu() != null && this.getInsitu().equals(Boolean.toString(true));
    }

    private boolean isQuantityOnly(Set<String> valueTypes) {
        return valueTypes.size() == 1 && valueTypes.contains(QUANTITY);
    }

    public boolean isExpandWithNextValuesBeyondInterval() {
        if (!this.containsParameter("expandWithNextValuesBeyondInterval")) {
            return true;
        }
        return this.getAsBoolean("expandWithNextValuesBeyondInterval");
    }

    public boolean hasCache() {
        return this.containsParameter("cache");
    }

    public Optional<JsonNode> getCache() {
        return this.getAsNode("cache");
    }
}

