/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Set;
import org.n52.io.request.IoParameters;
import org.n52.io.request.RequestParameterSet;
import org.n52.io.request.StyleProperties;

public class RequestStyledParameterSet
extends RequestParameterSet {
    private final Map<String, StyleProperties> styleOptions;

    RequestStyledParameterSet(@JsonProperty(value="styleOptions", required=true) Map<String, StyleProperties> styleOptions) {
        this.styleOptions = styleOptions;
    }

    public int getWidth() {
        return this.getAsInt("width", 800);
    }

    public void setWidth(int width) {
        int w = width < 0 ? 800 : width;
        this.setParameter("width", w);
    }

    public int getHeight() {
        return this.getAsInt("height", 500);
    }

    public void setHeight(int height) {
        int h = height < 0 ? 500 : height;
        this.setParameter("height", h);
    }

    @Override
    public String[] getDatasets() {
        Set<String> datasetIds = this.styleOptions.keySet();
        return datasetIds.toArray(new String[0]);
    }

    public void setGrid(boolean grid) {
        this.setParameter("grid", grid);
    }

    public boolean isGrid() {
        return this.getAsBoolean("grid", true);
    }

    public boolean isLegend() {
        return this.getAsBoolean("legend", false);
    }

    public void setLegend(boolean legend) {
        this.setParameter("legend", legend);
    }

    public String getTimeFormat() {
        return this.getAsString("timeformat", "yyyy-MM-dd, HH:mm");
    }

    public StyleProperties getStyleProperties(String timeseriesId) {
        return this.styleOptions.get(timeseriesId);
    }

    public StyleProperties getReferenceDatasetStyleOptions(String timeseriesId, String referenceSeriesId) {
        if (!this.styleOptions.containsKey(timeseriesId)) {
            return null;
        }
        StyleProperties styleProperties = this.getStyleProperties(timeseriesId);
        Map<String, StyleProperties> properties = styleProperties.getReferenceValueStyleProperties();
        return properties.containsKey(referenceSeriesId) ? properties.get(referenceSeriesId) : null;
    }

    @Override
    public IoParameters toParameters() {
        this.setParameter("styles", this.styleOptions);
        return super.toParameters();
    }
}

