/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.locationtech.jts.geom.Point;
import org.n52.io.crs.BoundingBox;
import org.n52.io.crs.CRSUtils;
import org.n52.io.crs.WGS84Util;
import org.n52.io.request.VicinityDeserializer;
import org.n52.io.request.VicinitySerializer;
import org.opengis.referencing.FactoryException;

@JsonSerialize(using=VicinitySerializer.class)
@JsonDeserialize(using=VicinityDeserializer.class)
public class Vicinity {
    private String crs = "CRS:84";
    private Point center;
    private double radius;

    Vicinity() {
    }

    public Vicinity(Point center, double radius) {
        try {
            this.radius = radius;
            this.center = center;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse radius.");
        }
    }

    public BoundingBox calculateBounds() {
        return this.calculateBounds(CRSUtils.createEpsgStrictAxisOrder());
    }

    public BoundingBox calculateBounds(CRSUtils crsUtils) {
        double latInRad = Math.toRadians(this.center.getY());
        double latitudeDelta = WGS84Util.getLatitudeDelta(this.radius);
        double longitudeDelta = WGS84Util.getLongitudeDelta(latInRad, this.radius);
        double llEasting = WGS84Util.normalizeLongitude(this.center.getX() - longitudeDelta);
        double llNorthing = WGS84Util.normalizeLatitude(this.center.getY() - latitudeDelta);
        double urEasting = WGS84Util.normalizeLongitude(this.center.getX() + longitudeDelta);
        double urNorthing = WGS84Util.normalizeLatitude(this.center.getY() + latitudeDelta);
        try {
            if (crsUtils.isLatLonAxesOrder(this.crs)) {
                Point ll = crsUtils.createPoint(llNorthing, llEasting, this.crs);
                Point ur = crsUtils.createPoint(urNorthing, urEasting, this.crs);
                return new BoundingBox(ll, ur, this.crs);
            }
            Point ll = crsUtils.createPoint(llEasting, llNorthing, this.crs);
            Point ur = crsUtils.createPoint(urEasting, urNorthing, this.crs);
            return new BoundingBox(ll, ur, this.crs);
        }
        catch (FactoryException e) {
            throw new IllegalStateException("Illegal CRS parameter: " + this.crs, e);
        }
    }

    public void setCrs(String crs) {
        if (crs != null) {
            this.crs = crs;
        }
    }

    public String getCrs() {
        return this.crs;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public Point getCenter() {
        return this.center;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [ ");
        sb.append("Center: ").append(this.center).append(", ");
        sb.append("Radius: ").append(this.radius).append(" km");
        return sb.append(" ]").toString();
    }
}

