/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.n52.io.geojson.FeatureOutputSerializer;
import org.n52.io.geojson.GeoJSONFeature;
import org.n52.io.geojson.GeoJSONObject;
import org.n52.io.response.AbstractOutput;
import org.n52.io.response.OptionalOutput;

@JsonSerialize(using=FeatureOutputSerializer.class, as=GeoJSONObject.class)
public class FeatureOutput
extends AbstractOutput
implements GeoJSONFeature {
    public static final String COLLECTION_PATH = "features";
    public static final String PROPERTIES = "properties";
    public static final String GEOMETRY = "geometry";
    private OptionalOutput<Geometry> geometry;

    @Override
    protected String getCollectionName() {
        return COLLECTION_PATH;
    }

    @Override
    public Geometry getGeometry() {
        return this.getIfSerialized(this.geometry);
    }

    @Override
    public void setGeometry(OptionalOutput<Geometry> geometry) {
        this.geometry = geometry;
    }

    @Override
    public boolean isSetGeometry() {
        return this.isSet(this.geometry) && this.geometry.isSerialize();
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.nullSafePut("label", this.getLabel(), properties);
        this.nullSafePut("domainId", this.getDomainId(), properties);
        this.nullSafePut("href", this.getHref(), properties);
        return properties;
    }

    private void nullSafePut(String key, Object value, Map<String, Object> container) {
        if (value != null) {
            container.put(key, value);
        }
    }
}

