/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.dataset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.DatasetMetadata;

public class Data<V extends AbstractValue<?>>
implements Serializable {
    private static final long serialVersionUID = 3119211667773416585L;
    private final List<V> values = new ArrayList<V>();
    private DatasetMetadata<V> metadata;

    public Data() {
        this(null);
    }

    public Data(DatasetMetadata<V> metadata) {
        this.metadata = metadata;
    }

    public void addValues(V[] toAdd) {
        if (toAdd != null && toAdd.length > 0) {
            this.values.addAll(Arrays.asList(toAdd));
        }
    }

    public Data<V> addNewValue(V value) {
        this.values.add(value);
        return this;
    }

    public Data<V> addData(Data<V> toAdd) {
        Data<V> data = new Data<V>(this.metadata);
        data.values.addAll(Stream.concat(this.values.stream(), toAdd.values.stream()).collect(Collectors.toList()));
        return data;
    }

    @JsonSerialize(typing=JsonSerialize.Typing.STATIC)
    public List<V> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public long size() {
        return this.values.size();
    }

    public void setMetadata(DatasetMetadata<V> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="extra")
    public DatasetMetadata<V> getMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public boolean hasMetadata() {
        return this.metadata != null && this.hasReferenceValues() && this.metadata.hasValueBeforeTimespan() && this.metadata.hasValueAfterTimespan();
    }

    @JsonIgnore
    public boolean hasReferenceValues() {
        return this.metadata != null && this.metadata.hasReferenceValues();
    }
}

