/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.dataset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import org.n52.io.request.IoParameters;
import org.n52.io.request.StyleProperties;
import org.n52.io.response.OptionalOutput;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.StatusInterval;
import org.n52.io.response.dataset.DatasetParameters;
import org.n52.io.response.dataset.StationOutput;
import org.n52.io.response.dataset.quantity.QuantityDatasetOutput;

public class TimeseriesMetadataOutput
extends QuantityDatasetOutput {
    public static final String COLLECTION_PATH = "timeseries";
    public static final String STATION = "station";
    public static final String RENDERING_HINTS = "renderingHints";
    public static final String STATUS_INTERVALS = "statusIntervals";
    private OptionalOutput<StationOutput> station;
    @Deprecated
    private OptionalOutput<StyleProperties> renderingHints;
    @Deprecated
    private OptionalOutput<Collection<StatusInterval>> statusIntervals;

    public TimeseriesMetadataOutput(IoParameters parameters) {
        this.setValue("valueType", "quantity", parameters, this::setValueType);
    }

    @Override
    @JsonIgnore
    public String getValueType() {
        return super.getValueType();
    }

    public StationOutput getStation() {
        return this.getIfSerialized(this.station);
    }

    public void setStation(OptionalOutput<StationOutput> station) {
        this.station = station;
    }

    @Deprecated
    public StyleProperties getRenderingHints() {
        return this.getIfSerialized(this.renderingHints);
    }

    @Deprecated
    public void setRenderingHints(OptionalOutput<StyleProperties> renderingHints) {
        this.renderingHints = renderingHints;
    }

    @Deprecated
    public Collection<StatusInterval> getStatusIntervals() {
        return this.getIfSerializedCollection(this.statusIntervals);
    }

    @Deprecated
    public void setStatusIntervals(OptionalOutput<Collection<StatusInterval>> statusIntervals) {
        this.statusIntervals = statusIntervals;
    }

    @Override
    @JsonProperty(value="parameters")
    public DatasetParameters getDatasetParameters() {
        DatasetParameters datasetParameters = super.getDatasetParameters();
        return datasetParameters != null ? new AdaptedSeriesParameters(datasetParameters) : null;
    }

    private static class AdaptedSeriesParameters
    extends DatasetParameters {
        private final DatasetParameters parameters;

        AdaptedSeriesParameters(DatasetParameters parameters) {
            this.parameters = parameters == null ? new DatasetParameters() : parameters;
        }

        @Override
        public ParameterOutput getPlatform() {
            return null;
        }

        @Override
        public void setPhenomenon(ParameterOutput phenomenon) {
            this.parameters.setPhenomenon(phenomenon);
        }

        @Override
        public void setProcedure(ParameterOutput procedure) {
            this.parameters.setProcedure(procedure);
        }

        @Override
        public void setCategory(ParameterOutput category) {
            this.parameters.setCategory(category);
        }

        @Override
        public void setOffering(ParameterOutput offering) {
            this.parameters.setOffering(offering);
        }

        @Override
        public void setService(ParameterOutput service) {
            this.parameters.setService(service);
        }

        @Override
        public void setPlatform(ParameterOutput platform) {
            this.parameters.setPlatform(platform);
        }

        @Override
        public ParameterOutput getPhenomenon() {
            return this.parameters.getPhenomenon();
        }

        @Override
        public ParameterOutput getProcedure() {
            return this.parameters.getProcedure();
        }

        @Override
        public ParameterOutput getCategory() {
            return this.parameters.getCategory();
        }

        @Override
        public ParameterOutput getOffering() {
            return this.parameters.getOffering();
        }

        @Override
        public ParameterOutput getService() {
            return this.parameters.getService();
        }
    }
}

