/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.style;

import org.n52.io.request.StyleProperties;
import org.n52.io.style.Style;

public class BarStyle
extends Style {
    private static final String BAR_INTERVAL = "interval";
    private static final String BAR_WIDTH = "width";
    private static final String DEFAULT_BAR_INTERVAL = "byDay";
    private static final double DEFAULT_BAR_WIDTH = 0.8;

    public String getBarInterval() {
        if (this.hasProperty(BAR_INTERVAL)) {
            return this.getPropertyAsString(BAR_INTERVAL);
        }
        return DEFAULT_BAR_INTERVAL;
    }

    public double getBarMargin() {
        if (this.hasProperty(BAR_WIDTH)) {
            return 1.0 - this.getPropertyAsDouble(BAR_WIDTH);
        }
        return 0.8;
    }

    public static BarStyle createBarStyle(StyleProperties options) {
        if (options == null || options.getProperties().isEmpty()) {
            return BarStyle.createDefaultBarStyle();
        }
        BarStyle barStyleOptions = new BarStyle();
        barStyleOptions.setProperties(options.getProperties());
        return barStyleOptions;
    }

    public static BarStyle createDefaultBarStyle() {
        return new BarStyle();
    }
}

