/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.spi.geo;

import org.locationtech.jts.geom.Geometry;
import org.n52.io.crs.CRSUtils;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.StationOutput;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformationService.class);

    protected void transformInline(StationOutput station, IoParameters parameters) {
        String crs = parameters.getCrs();
        if ("CRS:84".equals(crs)) {
            return;
        }
        Geometry geometry = this.transform(station.getGeometry(), parameters);
        station.setValue("geometry", geometry, parameters, station::setGeometry);
    }

    public Geometry transform(Geometry geometry, IoParameters query) {
        String crs = query.getCrs();
        if ("CRS:84".equals(crs)) {
            return geometry;
        }
        return this.transformGeometry(query, geometry, crs);
    }

    private Geometry transformGeometry(IoParameters query, Geometry geometry, String crs) throws RuntimeException {
        try {
            CRSUtils crsUtils = query.isForceXY() ? CRSUtils.createEpsgForcedXYAxisOrder() : CRSUtils.createEpsgStrictAxisOrder();
            return geometry != null ? crsUtils.transformInnerToOuter(geometry, crs) : geometry;
        }
        catch (TransformException e) {
            this.throwRuntimeException(crs, e);
        }
        catch (FactoryException e) {
            LOGGER.debug("Couldn't create geometry factory", (Throwable)e);
        }
        return geometry;
    }

    private void throwRuntimeException(String crs, TransformException e) throws RuntimeException {
        throw new RuntimeException("Could not transform to requested CRS: " + crs, e);
    }
}

