/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.spi.geo;

import org.locationtech.jts.geom.Geometry;
import org.n52.io.request.IoParameters;
import org.n52.io.response.GeometryOutput;
import org.n52.io.response.OutputCollection;
import org.n52.series.spi.geo.TransformationService;
import org.n52.series.spi.srv.ParameterService;

public class TransformingGeometryOutputService
extends ParameterService<GeometryOutput> {
    private final ParameterService<GeometryOutput> composedService;
    private final TransformationService transformationService;

    public TransformingGeometryOutputService(ParameterService<GeometryOutput> toCompose) {
        this.composedService = toCompose;
        this.transformationService = new TransformationService();
    }

    @Override
    public OutputCollection<GeometryOutput> getExpandedParameters(IoParameters query) {
        return this.transform(query, this.composedService.getExpandedParameters(query));
    }

    @Override
    public OutputCollection<GeometryOutput> getCondensedParameters(IoParameters query) {
        return this.transform(query, this.composedService.getCondensedParameters(query));
    }

    @Override
    public OutputCollection<GeometryOutput> getParameters(String[] items, IoParameters query) {
        return this.transform(query, this.composedService.getParameters(items, query));
    }

    @Override
    public GeometryOutput getParameter(String item, IoParameters query) {
        return this.transform(this.composedService.getParameter(item, query), query);
    }

    @Override
    public boolean exists(String id, IoParameters parameters) {
        return this.composedService.exists(id, parameters);
    }

    private OutputCollection<GeometryOutput> transform(IoParameters query, OutputCollection<GeometryOutput> infos) {
        if (infos != null) {
            for (GeometryOutput info : infos) {
                this.transformInline(info, query);
            }
        }
        return infos;
    }

    private GeometryOutput transform(GeometryOutput info, IoParameters parameters) {
        this.transformInline(info, parameters);
        return info;
    }

    private void transformInline(GeometryOutput info, IoParameters parameters) {
        Geometry geometry = this.transformationService.transform(info.getGeometry(), parameters);
        info.setValue("geometry", geometry, parameters, info::setGeometry);
    }
}

