/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import org.junit.Assert;
import org.junit.Test;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;

public class FilterResolverTest {
    private FilterResolver createResolver(IoParameters resolver) {
        return new FilterResolver(resolver);
    }

    @Test
    public void when_defaults_then_behaveBackwardsCompatible() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallBehaveBackwardsCompatible());
    }

    @Test
    public void when_setPlatformTypeFilter_then_dontBehaveBackwardsCompatible() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"blah"}));
        Assert.assertFalse((boolean)resolver.shallBehaveBackwardsCompatible());
    }

    @Test
    public void when_setDatasetTypeFiltre_then_dontBehaveBackwardsCompatible() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("valueTypes", new String[]{"blah"}));
        Assert.assertFalse((boolean)resolver.shallBehaveBackwardsCompatible());
    }

    @Test
    public void when_defaults_then_allPlatformGeometryFiltersActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_defaults_then_allObservedGeometryFiltersActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
    }

    @Test
    public void when_stationaryPlatformsFilter_then_sitesAndAndRemoteFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"stationary"}));
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_mobilePlatformsFilter_then_tracksAndRemoteFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"mobile"}));
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_insituPlatformsFilter_then_sitesAndtracksFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"insitu"}));
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertFalse((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertFalse((boolean)resolver.shallIncludeObservedGeometriesDynamic());
    }

    @Test
    public void when_remotePlatformsFilter_then_allGeometriesFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"remote"}));
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_allObservedGeometries_then_allObservedGeometryFiltersActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("observedGeometries", new String[]{"all"}));
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
    }

    @Test
    public void when_allPlatformGeometries_then_allPlatformGeometryFiltersActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformGeometries", new String[]{"all"}));
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_allPlatformsRemoteGeometries_then_allGeometriesFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"remote"}).extendWith("observedGeometries", new String[]{"all"}));
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_allGeometriesStationaryPlatforms_then_allSitesFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("observedGeometries", new String[]{"all"}).extendWith("platformTypes", new String[]{"stationary"}));
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_allGeometriesMobilePlatforms_then_allTracksFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"mobile"}).extendWith("observedGeometries", new String[]{"all"}));
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_sitePlatformGeometries_then_siteFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformGeometries", new String[]{"site"}));
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_trackPlatformGeometries_then_trackFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformGeometries", new String[]{"track"}));
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_trackPlatformGeometries_then_siteFilterInactive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformGeometries", new String[]{"track"}));
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_staticObservedGeometries_then_staticFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("observedGeometries", new String[]{"static"}));
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertFalse((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_dynamicObservedGeometries_then_dynamicFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("observedGeometries", new String[]{"dynamic"}));
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_defaults_then_insituFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludeInsituPlatformTypes());
    }

    @Test
    public void when_defaults_then_stationaryFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludeStationaryPlatformTypes());
    }

    @Test
    public void when_defaults_then_remoteFilterInactive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
    }

    @Test
    public void when_defaults_then_mobileFilterInactive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
    }

    @Test
    public void when_setMobile_then_allMobilesFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"mobile"}));
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeInsituPlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeStationaryPlatformTypes());
    }

    @Test
    public void when_setRemote_then_allRemotesFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"remote"}));
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeStationaryPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeInsituPlatformTypes());
    }

    @Test
    public void when_setMobileRemote_then_allMobileRemotesFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"mobile", "remote"}));
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeInsituPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeStationaryPlatformTypes());
    }

    @Test
    public void when_setMobileInsitu_then_allMobileInsitusFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"mobile", "insitu"}));
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeInsituPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeStationaryPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeRemotePlatformTypes());
    }

    @Test
    public void when_setStationaryInsitu_then_allStationaryInsitusFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"stationary", "insitu"}));
        Assert.assertTrue((boolean)resolver.shallIncludeInsituPlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeStationaryPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeMobilePlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeRemotePlatformTypes());
    }

    @Test
    public void when_setStationaryRemote_then_allStationaryRemotesFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"stationary", "remote"}));
        Assert.assertTrue((boolean)resolver.shallIncludeStationaryPlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeInsituPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeMobilePlatformTypes());
    }

    @Test
    public void when_setAllPlatformTypes_then_insituFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"all"}));
        Assert.assertTrue((boolean)resolver.shallIncludeInsituPlatformTypes());
    }

    @Test
    public void when_setAllPlatformTypes_then_stationaryFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"all"}));
        Assert.assertTrue((boolean)resolver.shallIncludeStationaryPlatformTypes());
    }

    @Test
    public void when_setAllPlatformTypes_then_remoteFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"all"}));
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
    }

    @Test
    public void when_setAllPlatformTypes_then_mobileFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"all"}));
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
    }

    @Test
    public void when_setAllDatasetTypes_then_noFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("valueTypes", new String[]{"all"}));
        Assert.assertTrue((boolean)resolver.shallIncludeAllDatasetTypes());
    }

    @Test
    public void when_setDatasetTypeFilter_then_filterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("valueTypes", new String[]{"foobar"}));
        Assert.assertFalse((boolean)resolver.shallIncludeAllDatasetTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeDatasetType("foobar"));
    }
}

