/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.n52.io.crs.BoundingBox;
import org.n52.io.request.Vicinity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VicinityTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(VicinityTest.class);
    private static final double ERROR_DELTA = 0.1;
    private String circleAroundNorthPole = "{ \"center\": {  \"type\": \"Point\", \"coordinates\": [-89.99,89.999] }, \"radius\": 500  }";
    private String circleAroundSouthPole = "{ \"center\": { \"type\": \"Point\", \"coordinates\": [-89.99,89.999] }, \"radius\": 500}";
    private String circleCenterAtGreenwhichAndEquator = "{ \"center\": { \"type\": \"Point\", \"coordinates\": [ 0,0 ] },\"radius\": 500 }";

    @Test
    public void shouldHaveInversedLatitudesWhenCenterIsOnEquator() {
        Vicinity vicinity = this.createRadiusAtNorthPole(this.circleCenterAtGreenwhichAndEquator);
        BoundingBox bounds = vicinity.calculateBounds();
        double llLatitudeOfSmallCircle = bounds.getLowerLeft().getY();
        double urLatitudeOfSmallCircle = bounds.getUpperRight().getY();
        Assert.assertThat((Object)llLatitudeOfSmallCircle, (Matcher)Matchers.closeTo((double)(-urLatitudeOfSmallCircle), (double)0.1));
    }

    @Test
    public void shouldHaveInversedLongitudesWhenCenterIsOnGreenwhich() {
        Vicinity vicinity = this.createRadiusAtNorthPole(this.circleCenterAtGreenwhichAndEquator);
        BoundingBox bounds = vicinity.calculateBounds();
        double llLongitudeOfGreatCircle = bounds.getLowerLeft().getX();
        double urLongitudeOnGreatCircle = bounds.getUpperRight().getX();
        Assert.assertThat((Object)llLongitudeOfGreatCircle, (Matcher)Matchers.closeTo((double)(-urLongitudeOnGreatCircle), (double)0.1));
    }

    @Test
    public void shouldHaveCommonLatitudeCircleWhenCenterIsNorthPole() {
        Vicinity vicinity = this.createRadiusAtNorthPole(this.circleAroundNorthPole);
        BoundingBox bounds = vicinity.calculateBounds();
        double llLatitudeOfSmallCircle = bounds.getLowerLeft().getY();
        double urLatitudeOfSmallCircle = bounds.getUpperRight().getY();
        Assert.assertThat((Object)llLatitudeOfSmallCircle, (Matcher)Matchers.closeTo((double)urLatitudeOfSmallCircle, (double)0.1));
    }

    @Test
    public void shouldHaveCommonLatitudeCircleWhenCenterIsSouthPole() {
        Vicinity vicinity = this.createRadiusAtNorthPole(this.circleAroundSouthPole);
        BoundingBox bounds = vicinity.calculateBounds();
        double llLatitudeOfSmallCircle = bounds.getLowerLeft().getY();
        double urLatitudeOfSmallCircle = bounds.getUpperRight().getY();
        Assert.assertThat((Object)llLatitudeOfSmallCircle, (Matcher)Matchers.closeTo((double)urLatitudeOfSmallCircle, (double)0.1));
    }

    private Vicinity createRadiusAtNorthPole(String circleJson) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (Vicinity)mapper.readValue(circleJson, Vicinity.class);
        }
        catch (JsonParseException e) {
            Assert.fail((String)"Could not parse GeoJson");
        }
        catch (IOException e) {
            LOGGER.error("Could not read GeoJSON: {}", (Object)circleJson, (Object)e);
            Assert.fail((String)"Could not read GeoJson");
        }
        return null;
    }
}

